/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.filter;

import java.util.StringTokenizer;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.filter.FilterHelper;
import uk.org.iscream.cms.server.filter.FilterMain;
import uk.org.iscream.cms.server.filter.FilterOperations;
import uk.org.iscream.cms.server.filter.PluginFilterManager;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.InvalidQueueException;
import uk.org.iscream.cms.server.util.InvalidXMLException;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.XMLPacket;
import uk.org.iscream.cms.server.util.XMLPacketMaker;

public class FilterThread
extends Thread {
    public final String REVISION = "$Revision: 1.32 $";
    Queue _queue;
    private String _name = FilterMain.NAME;
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    private ReferenceManager _refman = ReferenceManager.getInstance();

    public FilterThread(Queue queue) {
        this.setName("filter.FilterThread");
        this._queue = queue;
        this._logger.write(this.toString(), 4, "created");
    }

    public void run() {
        XMLPacketMaker xMLPacketMaker = new XMLPacketMaker();
        int n = this._queue.getQueue();
        String string = null;
        String string2 = "";
        FilterOperations filterOperations = null;
        while (true) {
            XMLPacket xMLPacket;
            block9: {
                try {
                    string = (String)this._queue.get(n);
                }
                catch (InvalidQueueException invalidQueueException) {
                    this._logger.write(this.toString(), 1, "Queue error: " + invalidQueueException);
                }
                string = string.indexOf(0) != -1 ? string.substring(0, string.indexOf(0)) : string.substring(0, string.length());
                StringTokenizer stringTokenizer = new StringTokenizer(new String(string), "\n");
                string = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string = string + stringTokenizer.nextToken();
                }
                xMLPacket = null;
                try {
                    xMLPacket = xMLPacketMaker.createXMLPacket(string);
                }
                catch (InvalidXMLException invalidXMLException) {
                    this._logger.write(this.toString(), 1, "Invalid XML: " + invalidXMLException);
                    continue;
                }
                try {
                    String string3 = ConfigurationProxy.getInstance().getProperty(FilterMain.NAME, "Filter.parentFilter");
                    if (string2.equals(string3)) break block9;
                    string2 = string3;
                    filterOperations = FilterHelper.narrow(this._refman.getCORBARef("iscream.Filter." + string2));
                    this._logger.write(this.toString(), 5, "Parent filter changed to: " + string2);
                }
                catch (PropertyNotFoundException propertyNotFoundException) {
                    continue;
                }
            }
            if (PluginFilterManager.getInstance().runFilters(xMLPacket)) {
                filterOperations.receiveXML(string);
                continue;
            }
            this._logger.write(this.toString(), 5, "An XML packet was sucessfully filtered from the system.");
        }
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.32 $");
    }
}

