/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.core.loggers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import uk.org.iscream.cms.server.core.LoggerImpl;
import uk.org.iscream.cms.server.util.FormatName;

public class FileLogger
implements LoggerImpl {
    public final String REVISION = "$Revision: 1.9 $";
    private String filename = System.getProperty("uk.org.iscream.cms.server.LoggerClass.FileLogger.filename");
    private BufferedWriter writer;
    private boolean open = false;
    private String _name = "Core";

    public FileLogger() throws IOException {
        if (!this.fileCheck()) {
            System.out.println(FormatName.formatLogLine(this.toString(), 0, "File check failed, construction terminated"));
            throw new IOException("File check failed, unable to create FileLog");
        }
        try {
            this.writer = new BufferedWriter(new FileWriter(this.filename, true));
            this.open = true;
        }
        catch (IOException iOException) {
            System.out.println(FormatName.formatLogLine(this.toString(), 0, "Attempt to setup writer failed - " + iOException.getMessage()));
        }
        this.write(this.toString(), 4, "started");
    }

    public synchronized void write(String string, int n) {
        if (this.open) {
            try {
                BufferedWriter bufferedWriter = this.writer;
                synchronized (bufferedWriter) {
                    this.writer.write(string);
                    this.writer.newLine();
                }
                this.writer.flush();
            }
            catch (IOException iOException) {
                System.out.println(FormatName.formatLogLine(this.toString(), 0, "Writing to logfile failed - " + iOException.getMessage()));
                this.open = false;
            }
        } else {
            System.out.println(FormatName.formatLogLine(this.toString(), 0, "Write failed - file not open"));
        }
    }

    public void clear() {
        if (this.open) {
            this.write(this.toString(), 3, "Attempting to clear logfile");
            try {
                this.open = false;
                this.writer.close();
                this.writer = new BufferedWriter(new FileWriter(this.filename));
                this.open = true;
            }
            catch (IOException iOException) {
                this.write(this.toString(), 1, "Attempt to clear logfile failed - " + iOException.getMessage());
                this.open = false;
            }
        } else {
            System.out.println(FormatName.formatLogLine(this.toString(), 0, "Clearing failed - file not open"));
        }
    }

    public void close() {
        if (this.open) {
            this.write(this.toString(), 3, "Attempting to terminate logging");
            try {
                this.open = false;
                this.writer.close();
            }
            catch (IOException iOException) {
                this.write(this.toString(), 1, "Attempt to close logfile failed - " + iOException.getMessage());
                this.open = false;
            }
        } else {
            System.out.println(FormatName.formatLogLine(this.toString(), 0, "Close failed - file not open"));
        }
    }

    public void open(String string) throws IOException {
        if (this.open) {
            this.write(this.toString(), 2, "Open failed - a file is already open");
        } else {
            this.filename = string;
            if (!this.fileCheck()) {
                System.out.println(FormatName.formatLogLine(this.toString(), 0, "File check failed, construction terminated"));
                throw new IOException("File check failed, unable to create FileLog");
            }
            try {
                this.writer = new BufferedWriter(new FileWriter(string, true));
                this.open = true;
            }
            catch (IOException iOException) {
                System.out.println(FormatName.formatLogLine(this.toString(), 0, "Attempt to open writer failed - " + iOException.getMessage()));
            }
        }
    }

    public void suspend() {
        if (this.open) {
            this.write(this.toString(), 3, "Writing suspended");
            this.open = false;
        } else {
            System.out.println(FormatName.formatLogLine(this.toString(), 0, "Suspend failed - file not open"));
        }
    }

    public void resume() {
        if (this.open) {
            System.out.println(FormatName.formatLogLine(this.toString(), 0, "Resume failed - file open"));
        } else {
            this.open = true;
            this.write(this.toString(), 3, "Writing resumed");
        }
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.9 $");
    }

    private boolean fileCheck() {
        boolean bl = false;
        try {
            File file = new File(this.filename);
            if (file.exists()) {
                if (file.isFile() && file.canWrite()) {
                    bl = true;
                }
            } else {
                file.createNewFile();
                bl = true;
            }
        }
        catch (IOException iOException) {
            System.out.println(FormatName.formatLogLine(this.toString(), 0, "File check failed - " + iOException.getMessage()));
        }
        return bl;
    }

    private void write(String string, int n, String string2) {
        this.write(FormatName.formatLogLine(string, n, string2), n);
    }
}

