/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.core;

import uk.org.iscream.cms.server.componentmanager.Component;
import uk.org.iscream.cms.server.componentmanager.ComponentStartException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.ConfigurationManagerServant;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.core.LoggerImpl;
import uk.org.iscream.cms.server.core.LoggerServant;
import uk.org.iscream.cms.server.util.FormatName;

public class Core
implements Component {
    public static final String REVISION = "$Revision: 1.25 $";
    public static final String NAME = "Core";
    private String _name = "Core";
    private Logger _logger;
    private ReferenceManager _refman = ReferenceManager.getInstance();

    public void start() throws ComponentStartException {
        String string = System.getProperty("uk.org.iscream.cms.server.LoggerClass");
        String string2 = System.getProperty("uk.org.iscream.cms.server.LoggerPackage");
        LoggerImpl loggerImpl = null;
        try {
            loggerImpl = (LoggerImpl)ClassLoader.getSystemClassLoader().loadClass(string2 + "." + string).newInstance();
        }
        catch (Exception exception) {
            throw new ComponentStartException("unable to load logging class");
        }
        LoggerServant loggerServant = new LoggerServant(loggerImpl);
        this._refman.bindToOrb(loggerServant, "iscream.Logger");
        this._logger = this._refman.getLogger();
        ConfigurationManagerServant configurationManagerServant = new ConfigurationManagerServant();
        this._refman.bindToOrb(configurationManagerServant, "iscream.ConfigurationManager");
        this._logger.write(this.toString(), 4, "started");
    }

    public boolean depCheck() {
        return true;
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), REVISION);
    }
}

