/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.omg.CORBA.Object;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.CircularIncludeException;
import uk.org.iscream.cms.server.core.Configuration;
import uk.org.iscream.cms.server.core.ConfigurationHelper;
import uk.org.iscream.cms.server.core.ConfigurationManagerPOA;
import uk.org.iscream.cms.server.core.ConfigurationServant;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.util.FormatName;

class ConfigurationManagerServant
extends ConfigurationManagerPOA {
    public final String REVISION = "$Revision: 1.18 $";
    private String _name = "Core";
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    private ReferenceManager _refman = ReferenceManager.getInstance();
    private String _configPath = System.getProperty("uk.org.iscream.cms.server.ConfigurationLocation");
    private String _systemConfigFile = System.getProperty("uk.org.iscream.cms.server.SystemConfigurationFile");
    private Configuration _systemConfig;
    private Properties _systemConfigHolder;

    ConfigurationManagerServant() {
        this.loadSystemConfig();
        this._logger.write(this.toString(), 4, "started");
        this._logger.write(this.toString(), 3, "configuration location - " + this._configPath);
        this._logger.write(this.toString(), 3, "system configuration file - " + this._systemConfigFile);
    }

    public Configuration getConfiguration(String string) {
        java.lang.Object object;
        String string2;
        java.lang.Object object2;
        this._logger.write(this.toString(), 3, "got request for " + string);
        if (this.isModified(this._systemConfig.getFileList(), this._systemConfig.getLastModified())) {
            this._logger.write(this.toString(), 3, "system config changed");
            this.loadSystemConfig();
        }
        LinkedList linkedList = this.getGroupMembership(string);
        linkedList.addFirst(string);
        LinkedList linkedList2 = new LinkedList();
        LinkedList linkedList3 = null;
        if (string.startsWith("Host.")) {
            object2 = string.substring(5);
            try {
                string2 = "Host." + InetAddress.getByName((String)object2).getHostAddress();
                linkedList3 = this.getGroupMembership(string2);
                linkedList3.addFirst(string2);
                linkedList2.addAll(linkedList3);
            }
            catch (UnknownHostException unknownHostException) {
                this._logger.write(this.toString(), 1, "could not resolve hostname - " + (String)object2);
            }
        }
        linkedList2.addAll(linkedList);
        object2 = linkedList2.iterator();
        string2 = "";
        while (object2.hasNext()) {
            object = (String)object2.next();
            this._logger.write(this.toString(), 5, "looking for config entry for - " + (String)object);
            String string3 = this._systemConfig.getProperty("config." + (String)object);
            if (string3 != null) {
                this._logger.write(this.toString(), 5, "looking for config tree in - " + string3);
                String string4 = null;
                try {
                    string4 = this.getIncludedFiles(string3, "") + ";";
                }
                catch (Exception exception) {
                    this._logger.write(this.toString(), 1, "ERROR - " + exception);
                }
                if (string4 == null) continue;
                string2 = string2 + string4;
                continue;
            }
            this._logger.write(this.toString(), 5, "no config entry for - " + (String)object);
        }
        string2 = this._systemConfigFile + ";" + string2;
        this._logger.write(this.toString(), 5, "config tree - " + string2);
        object = this.buildConfiguration(string2);
        return object;
    }

    public boolean isModified(String string, long l) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            File file = new File(this._configPath, stringTokenizer.nextToken());
            long l2 = file.lastModified();
            if (l2 <= l) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.18 $");
    }

    private String getIncludedFiles(String string, String string2) throws IOException, FileNotFoundException, Exception {
        if (this.hasDuplicate(string, string2) || string.equals(this._systemConfigFile)) {
            throw new CircularIncludeException(string + " is included more than once");
        }
        string2 = string2 + string + ";";
        Properties properties = new Properties();
        properties.load(new FileInputStream(new File(this._configPath, string)));
        String string3 = properties.getProperty("include");
        if (string3 == null) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
        String string4 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string4 = this.getIncludedFiles(stringTokenizer.nextToken(), string2) + ";" + string4;
        }
        return string4 + string;
    }

    private boolean hasDuplicate(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            if (!string.equals(stringTokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }

    private void loadSystemConfig() {
        this._logger.write(this.toString(), 3, "reloading " + this._systemConfigFile);
        try {
            File file = new File(this._configPath, this._systemConfigFile);
            this._systemConfigHolder = new Properties();
            this._systemConfigHolder.load(new FileInputStream(file));
            ConfigurationServant configurationServant = new ConfigurationServant(this._systemConfigHolder, this._systemConfigFile, file.lastModified());
            Object object = this._refman.getRootPOA().servant_to_reference(configurationServant);
            this._systemConfig = ConfigurationHelper.narrow(object);
        }
        catch (Exception exception) {
            this._logger.write(this.toString(), 0, "ERROR: " + exception.getMessage());
        }
    }

    private LinkedList getGroupMembership(String string) {
        this._logger.write(this.toString(), 5, "searching group members for - " + string);
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = new TreeSet(((Hashtable)this._systemConfigHolder).keySet()).iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith("group.")) continue;
            String string3 = this._systemConfig.getProperty(string2);
            if (string3.indexOf(string) != -1) {
                linkedList.add(string2.substring(6));
                continue;
            }
            if (string3.indexOf("*") == -1 || !this.wildcardCheck(string, string3)) continue;
            linkedList.add(string2.substring(6));
        }
        return linkedList;
    }

    private boolean wildcardCheck(String string, String string2) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.indexOf("*") == -1) continue;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "*");
            String string4 = "";
            int n = 0;
            if (!string3.startsWith("*")) {
                string4 = stringTokenizer2.nextToken();
                if (string.startsWith(string4)) {
                    bl = true;
                    n = string4.length();
                }
            } else {
                bl = true;
            }
            if (!bl) continue;
            while (stringTokenizer2.hasMoreTokens()) {
                string4 = stringTokenizer2.nextToken();
                if (string.substring(n).indexOf(string4) == -1) {
                    bl = false;
                    break;
                }
                bl = true;
                n += string.substring(n).indexOf(string4) + string4.length();
            }
            if (!string3.endsWith("*") && bl) {
                if (string.endsWith(string4)) {
                    this._logger.write(this.toString(), 5, "wildcard match found for - " + string + " in - " + string3);
                    break;
                }
                bl = false;
                continue;
            }
            if (!bl) continue;
            this._logger.write(this.toString(), 5, "wildcard match found for - " + string + " in - " + string3);
            break;
        }
        return bl;
    }

    private Configuration buildConfiguration(String string) {
        Configuration configuration = null;
        if (!string.equals("")) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                long l = 0L;
                long l2 = 0L;
                Properties properties = null;
                java.lang.Object var10_8 = null;
                Properties properties2 = new Properties();
                while (stringTokenizer.hasMoreTokens()) {
                    properties = new Properties(properties2);
                    File file = new File(this._configPath, stringTokenizer.nextToken());
                    l2 = file.lastModified();
                    if (l2 > l) {
                        l = l2;
                    }
                    properties.load(new FileInputStream(file));
                    properties2 = properties;
                }
                ConfigurationServant configurationServant = new ConfigurationServant(properties, string, l);
                Object object = this._refman.getRootPOA().servant_to_reference(configurationServant);
                configuration = ConfigurationHelper.narrow(object);
                this._logger.write(this.toString(), 5, "returning built configuration");
            }
            catch (Exception exception) {
                this._logger.write(this.toString(), 1, "ERROR - " + exception);
            }
        } else {
            this._logger.write(this.toString(), 5, "no configured config, returning " + this._systemConfigFile);
            configuration = this._systemConfig;
        }
        return configuration;
    }
}

