/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.componentmanager;

import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import uk.org.iscream.cms.server.componentmanager.ComponentCORBAException;
import uk.org.iscream.cms.server.core.ConfigurationManager;
import uk.org.iscream.cms.server.core.ConfigurationManagerHelper;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.core.LoggerHelper;
import uk.org.iscream.cms.server.util.FormatName;

public class ReferenceManager {
    public final String REVISION = "$Revision: 1.16 $";
    private ORB _orb = ORB.init(new String[0], null);
    private NamingContextExt _ns;
    private POA _rootPOA;
    private ConfigurationManager _cm;
    private Logger _logger;
    private String _name = null;
    private static ReferenceManager _instance = null;

    public static synchronized ReferenceManager getInstance() {
        if (_instance == null) {
            _instance = new ReferenceManager();
        }
        return _instance;
    }

    private ReferenceManager() {
    }

    public Object getCORBARef(String string) {
        Object object = null;
        try {
            object = this.getNS().resolve(this.getNS().to_name(string));
        }
        catch (CannotProceed cannotProceed) {
            this.dieWithError("\nCRITICAL:Naming Service Cannot Proceed - when resolving reference to " + string + "!\n" + "         Please check with your CORBA naming service provider.");
        }
        catch (InvalidName invalidName) {
            this.dieWithError("\nCRITICAL:Invalid Name - when resolving reference to " + string + "!\n" + "         Please check with your CORBA naming service provider.");
        }
        catch (NotFound notFound) {
            this.recoverWithError("\nCRITICAL:Not Found - when resolving reference to " + string + "!\n" + "         Please check that this component is running.");
        }
        return object;
    }

    public void bindToOrb(Servant servant, String string) {
        try {
            this.getNS().bind(this.getNS().to_name(string), this.getRootPOA().servant_to_reference(servant));
        }
        catch (WrongPolicy wrongPolicy) {
            this.dieWithError("\nCRITICAL:Wrong POA Policy - when binding " + string + "!\n" + "         This indicates an error with your ORB.");
        }
        catch (ServantNotActive servantNotActive) {
            this.dieWithError("\nCRITICAL:ServantNotActive - when binding " + string + "!\n" + "         This indicates an error with your ORB.");
        }
        catch (InvalidName invalidName) {
            this.dieWithError("\nCRITICAL:Invalid Name - when binding " + string + "!\n" + "         Please check with your CORBA naming service provider.");
        }
        catch (CannotProceed cannotProceed) {
            this.dieWithError("\nCRITICAL:Naming Service Cannot Proceed - when binding " + string + "!\n" + "         Please check with your CORBA naming service provider.");
        }
        catch (NotFound notFound) {
            this.recoverWithError("\nCRITICAL:Naming Service Not Found - when binding " + string + "!\n" + "         Please check with your CORBA naming service provider.");
        }
        catch (AlreadyBound alreadyBound) {
            this.dieWithError("\nCRITICAL:Already Bound - when binding " + string + "!\n" + "         Another component with this name is already running.");
        }
    }

    public void activatePOA() {
        try {
            this.getRootPOA().the_POAManager().activate();
        }
        catch (AdapterInactive adapterInactive) {
            this.dieWithError("\nCRITICAL:POA Set Inactive - when trying to activate POA!\n         This indicates an error with your ORB.");
        }
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.16 $");
    }

    private void recoverWithError(String string) throws ComponentCORBAException {
        if (this._logger != null) {
            this._logger.write(this.toString(), 2, "component CORBA error - " + string);
        }
        throw new ComponentCORBAException(string);
    }

    private void dieWithError(String string) {
        System.err.println(string);
        if (this._logger != null) {
            this._logger.write(this.toString(), 0, string);
        }
        System.exit(1);
    }

    public ORB getORB() {
        return this._orb;
    }

    public POA getRootPOA() {
        if (this._rootPOA == null) {
            Object object = null;
            try {
                object = this.getORB().resolve_initial_references("RootPOA");
            }
            catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
                this.dieWithError("\nCRITICAL:Unable to resolve reference to the RootPOA!\n         This indicates an error with your ORB.");
            }
            this._rootPOA = POAHelper.narrow(object);
        }
        return this._rootPOA;
    }

    public NamingContextExt getNS() {
        if (this._ns == null) {
            Object object = null;
            try {
                object = this.getORB().resolve_initial_references("NameService");
            }
            catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
                this.dieWithError("\nCRITICAL:Unable to resolve reference to the Naming Service!\n         Please check with your CORBA naming service provider.");
            }
            this._ns = NamingContextExtHelper.narrow(object);
        }
        if (this._ns == null) {
            this.dieWithError("\nCRITICAL:Unable to resolve reference to the Naming Service!\n         Please check with your CORBA naming service provider.");
        }
        return this._ns;
    }

    public ConfigurationManager getCM() {
        if (this._cm == null) {
            this._cm = ConfigurationManagerHelper.narrow(this.getCORBARef("iscream.ConfigurationManager"));
        }
        if (this._cm == null) {
            this.dieWithError("\nCRITICAL:Unable to resolve reference to the Configuration Manager!\n         Please check with your CORBA naming service provider.");
        }
        return this._cm;
    }

    public Logger getLogger() {
        if (this._logger == null) {
            this._logger = LoggerHelper.narrow(this.getCORBARef("iscream.Logger"));
        }
        return this._logger;
    }
}

