/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.componentmanager;

import java.util.HashMap;
import java.util.Iterator;
import org.omg.CORBA.MARSHAL;
import uk.org.iscream.cms.server.componentmanager.ConfigurationCache;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Configuration;
import uk.org.iscream.cms.server.core.ConfigurationManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.util.FormatName;

public class ConfigurationProxy
extends Thread {
    public static final String REVISION = "$Revision: 1.15 $";
    public final int DEFAULT_REFRESH_TIME = 60;
    private String _name = null;
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    private ReferenceManager _refman = ReferenceManager.getInstance();
    private ConfigurationManager _confman = ReferenceManager.getInstance().getCM();
    private HashMap _configCache = new HashMap();
    private boolean _running = true;
    private static ConfigurationProxy _instance;

    public static synchronized ConfigurationProxy getInstance() {
        if (_instance == null) {
            _instance = new ConfigurationProxy();
        }
        return _instance;
    }

    private ConfigurationProxy() {
        this.setName("componentmanager.ConfigurationProxy");
        this.start();
    }

    public void run() {
        while (this._running) {
            int n = 0;
            try {
                n = Integer.parseInt(this.getProperty("ConfigurationProxy", "ConfigurationProxy.updateTime"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 60;
                this._logger.write(this.toString(), 2, "Erronous ConfigurationProxy.updateTime value in configuration using default of " + n + " seconds");
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                n = 60;
                this._logger.write(this.toString(), 2, "ConfigurationProxy.updateTime value unavailable using default of " + n + " seconds");
            }
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ConfigurationProxy configurationProxy = this;
            synchronized (configurationProxy) {
                Iterator iterator = this._configCache.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    ConfigurationCache configurationCache = (ConfigurationCache)this._configCache.get(string);
                    if (!this._confman.isModified(configurationCache.getConfig().getFileList(), configurationCache.getConfig().getLastModified())) continue;
                    configurationCache.getConfig().disconnect();
                    configurationCache.setConfig(this._confman.getConfiguration(string));
                    configurationCache.setPropertyCache(new HashMap());
                }
            }
        }
    }

    public String getProperty(String string, String string2) throws PropertyNotFoundException {
        ConfigurationProxy configurationProxy = this;
        synchronized (configurationProxy) {
            String string3;
            if (!this._configCache.containsKey(string)) {
                this._configCache.put(string, new ConfigurationCache(this._confman.getConfiguration(string), new HashMap()));
            }
            ConfigurationCache configurationCache = (ConfigurationCache)this._configCache.get(string);
            HashMap hashMap = configurationCache.getPropertyCache();
            Configuration configuration = configurationCache.getConfig();
            if (!hashMap.containsKey(string2)) {
                try {
                    hashMap.put(string2, configuration.getProperty(string2));
                }
                catch (MARSHAL mARSHAL) {
                    hashMap.put(string2, null);
                }
            }
            if ((string3 = (String)hashMap.get(string2)) == null) {
                throw new PropertyNotFoundException("Could not locate the property \"" + string2 + "\" in the configuration \"" + string + "\"");
            }
            String string4 = string3;
            return string4;
        }
    }

    public String getFileList(String string) {
        ConfigurationProxy configurationProxy = this;
        synchronized (configurationProxy) {
            if (!this._configCache.containsKey(string)) {
                this._configCache.put(string, new ConfigurationCache(this._confman.getConfiguration(string), new HashMap()));
            }
            ConfigurationCache configurationCache = (ConfigurationCache)this._configCache.get(string);
            String string2 = configurationCache.getConfig().getFileList();
            return string2;
        }
    }

    public long getLastModified(String string) {
        ConfigurationProxy configurationProxy = this;
        synchronized (configurationProxy) {
            if (!this._configCache.containsKey(string)) {
                this._configCache.put(string, new ConfigurationCache(this._confman.getConfiguration(string), new HashMap()));
            }
            ConfigurationCache configurationCache = (ConfigurationCache)this._configCache.get(string);
            long l = configurationCache.getConfig().getLastModified();
            return l;
        }
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), REVISION);
    }
}

