/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.componentmanager;

import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.omg.CORBA.COMM_FAILURE;
import uk.org.iscream.cms.server.client.ClientMain;
import uk.org.iscream.cms.server.clientinterface.ClientInterfaceMain;
import uk.org.iscream.cms.server.componentmanager.Component;
import uk.org.iscream.cms.server.componentmanager.ComponentStartException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Core;
import uk.org.iscream.cms.server.dbinterface.DBInterface;
import uk.org.iscream.cms.server.filter.FilterMain;
import uk.org.iscream.cms.server.filtermanager.FilterManager;
import uk.org.iscream.cms.server.rootfilter.RootFilter;
import uk.org.iscream.cms.server.util.FormatName;

public class ComponentManager {
    public static final String REVISION = "$Revision: 1.38 $";
    public static final String toString = FormatName.getName("ComponentManager", null, "$Revision: 1.38 $");
    public static final String DEFAULTPROPERTIES = "./etc/default.properties";
    public static final int DEFAULT_COMPONENT_START_TIMEOUT = 5;
    private static LinkedList _componentsToStart;
    private static int _startTimeout;

    public static void main(String[] stringArray) {
        String string;
        Object object;
        System.out.println("-----------------------------------------");
        System.out.println("--- i-scream Server Component Manager ---");
        System.out.println("---   (c) 2001 The i-scream Project   ---");
        System.out.println("---    (http://www.i-scream.org.uk)   ---");
        System.out.println("-----------------------------------------");
        System.out.println("---          Starting System          ---");
        String string2 = DEFAULTPROPERTIES;
        String string3 = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-h")) {
                ComponentManager.usage();
            } else if (stringArray[n].equals("-f")) {
                string3 = stringArray[++n];
            } else if (stringArray[n].equals("-l")) {
                string2 = stringArray[++n];
            } else {
                ComponentManager.usage();
            }
            ++n;
        }
        System.out.println(toString + ": initialising - using " + string2);
        try {
            object = new Properties(System.getProperties());
            ((Properties)object).load(new FileInputStream(new File(string2)));
            System.setProperties((Properties)object);
        }
        catch (Exception exception) {
            System.err.println(toString + ": ERROR " + exception.getMessage());
            ComponentManager.usage();
        }
        System.out.println(toString + ": coming up");
        object = ReferenceManager.getInstance();
        ((ReferenceManager)object).activatePOA();
        String string4 = System.getProperty("uk.org.iscream.cms.server.ComponentList");
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ";");
        _componentsToStart = new LinkedList();
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            Component component = null;
            if (string.equalsIgnoreCase("core")) {
                component = new Core();
            } else if (string.equalsIgnoreCase("filtermanager")) {
                component = new FilterManager();
            } else if (string.equalsIgnoreCase("rootfilter")) {
                component = new RootFilter();
            } else if (string.equalsIgnoreCase("dbinterface")) {
                component = new DBInterface();
            } else if (string.equalsIgnoreCase("clientinterface")) {
                component = new ClientInterfaceMain();
            } else if (string.equalsIgnoreCase("filter")) {
                component = new FilterMain(string3);
            } else if (string.equalsIgnoreCase("client")) {
                component = new ClientMain();
            }
            if (component != null) {
                _componentsToStart.add(component);
                continue;
            }
            System.err.println(toString + ": WARNING unsupported component not started: " + string);
        }
        string = null;
        try {
            string = System.getProperty("uk.org.iscream.cms.server.ComponentTimeout");
            string.trim();
            _startTimeout = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            _startTimeout = 5;
            System.err.println(toString + ": unable to read uk.org.iscream.cms.server.ComponentTimeout value (" + string + "), using default!");
        }
        System.out.println(toString + ": using component start timeout of " + _startTimeout + " seconds");
        ComponentManager.startUp();
        while (true) {
            try {
                ((ReferenceManager)object).getORB().run();
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                System.out.println(toString + ": WARNING CORBA communications failure - " + cOMM_FAILURE.getMessage());
                System.out.println(toString + ": WARNING CORBA connections have been lost - attempting to restart!");
            }
            ComponentManager.startUp();
        }
    }

    private static void startUp() {
        boolean bl = true;
        Component component = null;
        while (bl) {
            Iterator iterator = _componentsToStart.iterator();
            LinkedList<Component> linkedList = new LinkedList<Component>();
            while (iterator.hasNext()) {
                component = (Component)iterator.next();
                System.out.println(toString + ": dependency checking component - " + component.toString());
                boolean bl2 = component.depCheck();
                if (bl2) {
                    System.out.println(toString + ": starting component - " + component.toString());
                    try {
                        component.start();
                    }
                    catch (ComponentStartException componentStartException) {
                        System.err.println(toString + ": ERROR starting component - " + component.toString());
                        System.err.println(toString + ": component reports - " + componentStartException.getMessage());
                        System.exit(1);
                    }
                    continue;
                }
                System.err.println(toString + ": WARNING Component reported dependency failure");
                System.err.println(toString + ": This could be because it can't communicate with components it needs.");
                linkedList.add(component);
            }
            if (linkedList.size() > 0) {
                System.err.println(toString + ": WARNING One or more components failed to start correctly.");
                System.err.println(toString + ": Will try again in " + _startTimeout + " seconds");
                _componentsToStart = linkedList;
                try {
                    Thread.sleep(_startTimeout * 1000);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            bl = false;
        }
        System.out.println(toString + ": running");
    }

    public static void usage() {
        System.out.println("USAGE: java uk.org.iscream.cms.server.componentmanager.ComponentManager <option>");
        System.out.println("   or: java -jar iscream.jar <option>");
        System.out.println("WHERE <option>:");
        System.out.println("      -l <filename> - the location of initial system properties");
        System.out.println("                      the default is ./etc/default.properties");
        System.out.println("      -f <name>     - the name of the filter (if there is one configured");
        System.out.println("      -h            - this help screen");
        System.exit(1);
    }

    static {
        _startTimeout = 0;
    }
}

