/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.clientinterface;

import org.omg.CORBA.COMM_FAILURE;
import uk.org.iscream.cms.server.client.Client;
import uk.org.iscream.cms.server.clientinterface.ClientInterfaceMain;
import uk.org.iscream.cms.server.clientinterface.CorbaControlHandlerServant;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.InvalidQueueException;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.StringUtils;

class CorbaDataHandler
extends Thread {
    public final String REVISION = "$Revision: 1.10 $";
    private String _name = ClientInterfaceMain.NAME;
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    private Queue _queue;
    private Client _client;
    private int _queueID;
    private boolean run;
    private CorbaControlHandlerServant _cchServant;

    public CorbaDataHandler(Client client, CorbaControlHandlerServant corbaControlHandlerServant) {
        this.setName("clientinterface.CorbaDataHandler");
        ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
        String string = "ClientInterface";
        try {
            int n = Integer.parseInt(configurationProxy.getProperty(string, "Queue.SizeLimit"));
            String string2 = configurationProxy.getProperty(string, "Queue.RemoveAlgorithm");
            int n2 = StringUtils.getStringPos(string2, Queue.algorithms);
            if (n2 != -1) {
                this._logger.write(this.toString(), 5, "Starting Queue with size limit of " + n + ", using remove algorithm " + string2);
                this._queue = new Queue(n, n2);
            } else {
                this._logger.write(this.toString(), 2, "Bad Queue Algorithm configuration, not known: " + string2);
                this._queue = new Queue();
            }
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 5, "Optional config not set: " + propertyNotFoundException);
            this._queue = new Queue();
        }
        catch (NumberFormatException numberFormatException) {
            this._logger.write(this.toString(), 2, "Bad Queue SizeLimit configuration: " + numberFormatException);
            this._queue = new Queue();
        }
        this._client = client;
        this._cchServant = corbaControlHandlerServant;
        this._logger.write(this.toString(), 4, "created");
    }

    public void run() {
        this._queueID = this._queue.getQueue();
        this.run = true;
        while (this.run) {
            try {
                String string = (String)this._queue.get(this._queueID);
                if (string == null) continue;
                try {
                    this._client.receiveXML(string);
                }
                catch (COMM_FAILURE cOMM_FAILURE) {
                    this.run = false;
                    this._logger.write(this.toString(), 1, "Connection failure, client shutdown? : " + cOMM_FAILURE);
                    this._cchServant.disconnect();
                }
            }
            catch (InvalidQueueException invalidQueueException) {
                this.run = false;
                this._logger.write(this.toString(), 1, "Queue failure: " + invalidQueueException);
            }
        }
        this._logger.write(this.toString(), 3, "Shutting Down");
        this._queue.removeQueue(this._queueID);
        this._queue.stopMonitor();
    }

    public void shutdown() {
        this.run = false;
        this._queue.releaseQueue(this._queueID);
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.10 $");
    }

    protected void finalize() throws Throwable {
        this._logger.write(this.toString(), 5, "finalized by GC");
    }

    public Queue getQueue() {
        return this._queue;
    }
}

