/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.clientinterface;

import org.omg.CORBA.Object;
import uk.org.iscream.cms.server.clientinterface.ClientInterfaceServant;
import uk.org.iscream.cms.server.clientinterface.CorbaClientListenerServant;
import uk.org.iscream.cms.server.clientinterface.PacketSorter;
import uk.org.iscream.cms.server.clientinterface.TCPClientListener;
import uk.org.iscream.cms.server.componentmanager.Component;
import uk.org.iscream.cms.server.componentmanager.ComponentCORBAException;
import uk.org.iscream.cms.server.componentmanager.ComponentStartException;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.util.FormatName;

public class ClientInterfaceMain
implements Component {
    public static final String REVISION = "$Revision: 1.25 $";
    private Logger _logger;
    private ReferenceManager _refman = ReferenceManager.getInstance();
    public static String NAME;

    public void start() throws ComponentStartException {
        this._logger = this._refman.getLogger();
        this._logger.write(this.toString(), 4, "coming up");
        ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
        String string = "ClientInterface";
        try {
            NAME = configurationProxy.getProperty(string, "ClientInterface.name");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            NAME = null;
            this._logger.write(this.toString(), 2, "ClientInterface name not set: " + propertyNotFoundException);
        }
        this._logger.write(this.toString(), 4, "configured");
        PacketSorter packetSorter = new PacketSorter();
        packetSorter.start();
        this._logger.write(this.toString(), 5, "starting servant for inbound data");
        ClientInterfaceServant clientInterfaceServant = new ClientInterfaceServant(packetSorter);
        this._refman.bindToOrb(clientInterfaceServant, "iscream.ClientInterface." + NAME);
        TCPClientListener tCPClientListener = new TCPClientListener(packetSorter);
        tCPClientListener.start();
        this._logger.write(this.toString(), 5, "starting servant for inbound clients");
        CorbaClientListenerServant corbaClientListenerServant = new CorbaClientListenerServant(packetSorter);
        this._refman.bindToOrb(corbaClientListenerServant, "iscream.ClientInterface.CorbaListener");
        this._logger.write(this.toString(), 4, "started");
    }

    public boolean depCheck() {
        try {
            Object object = this._refman.getCORBARef("iscream.Logger");
            object = this._refman.getCORBARef("iscream.ConfigurationManager");
        }
        catch (ComponentCORBAException componentCORBAException) {
            System.err.println(this.toString() + ": Dependency Failure: " + componentCORBAException);
            return false;
        }
        return true;
    }

    public String toString() {
        return FormatName.getName(NAME, this.getClass().getName(), REVISION);
    }
}

