/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.client.monitors;

import java.util.HashMap;
import uk.org.iscream.cms.server.client.Alert;
import uk.org.iscream.cms.server.client.MonitorManager;
import uk.org.iscream.cms.server.client.MonitorSkeleton;
import uk.org.iscream.cms.server.client.Register;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.XMLPacket;

public class UserCount__Monitor
extends MonitorSkeleton {
    public final String REVISION = "$Revision: 1.3 $";
    public final String DESC = "Monitors number of logged on users.";
    private String _name = "UserCount";
    private HashMap _hosts = new HashMap();

    public void analysePacket(XMLPacket xMLPacket) {
        String string = xMLPacket.getParam("packet.attributes.machine_name");
        if (!this._hosts.containsKey(string)) {
            this._hosts.put(string, new Register(string, this._name));
        }
        Register register = (Register)this._hosts.get(string);
        String string2 = xMLPacket.getParam("packet.users.count");
        String string3 = "User Count";
        int n = this.checkAttributeThreshold(string2, register);
        this.processAlert(n, string3, register, string, string2);
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.3 $");
    }

    public String getDescription() {
        return "Monitors number of logged on users.";
    }

    private int checkAttributeThreshold(String string, Register register) {
        int n = Alert.thresholdLevels.length - 1;
        while (n >= 0) {
            if (register.getThreshold(n) != -1.0 && string != null) {
                try {
                    double d = Double.parseDouble(string);
                    if (register.getThreshold(n) < d) {
                        return n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this._logger.write(this.toString(), 5, "possible errenous packet data, should be double value - " + string);
                }
            }
            --n;
        }
        return 0;
    }

    protected Queue getQueue() {
        return MonitorManager.getInstance().getDataQueue();
    }
}

