/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.client.monitors;

import java.text.NumberFormat;
import java.util.HashMap;
import uk.org.iscream.cms.server.client.Alert;
import uk.org.iscream.cms.server.client.MonitorManager;
import uk.org.iscream.cms.server.client.MonitorSkeleton;
import uk.org.iscream.cms.server.client.Register;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.XMLPacket;

public class Swap__Monitor
extends MonitorSkeleton {
    public final String REVISION = "$Revision: 1.7 $";
    public final String DESC = "Monitors Swap.";
    private String _name = "Swap";
    private HashMap _hosts = new HashMap();

    public void analysePacket(XMLPacket xMLPacket) {
        double d;
        double d2;
        String string = xMLPacket.getParam("packet.attributes.machine_name");
        if (!this._hosts.containsKey(string)) {
            this._hosts.put(string, new Register(string, this._name));
        }
        Register register = (Register)this._hosts.get(string);
        String string2 = "Swap In Use %";
        try {
            String string3 = xMLPacket.getParam("packet.swap.total");
            String string4 = xMLPacket.getParam("packet.swap.free");
            if (string3 == null || string4 == null) {
                throw new NumberFormatException("Memory data invalid");
            }
            d2 = Double.parseDouble(string3);
            d = Double.parseDouble(string4);
        }
        catch (NumberFormatException numberFormatException) {
            this._logger.write(this.toString(), 2, "Received packet from " + string + " with bad swap information" + numberFormatException);
            return;
        }
        double d3 = (1.0 - d / d2) * 100.0;
        int n = this.checkAttributeThreshold(d3, register);
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(2);
        String string5 = numberFormat.format(d3);
        this.processAlert(n, string2, register, string, string5);
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.7 $");
    }

    public String getDescription() {
        return "Monitors Swap.";
    }

    private int checkAttributeThreshold(double d, Register register) {
        int n = Alert.thresholdLevels.length - 1;
        while (n >= 0) {
            if (register.getThreshold(n) != -1.0 && register.getThreshold(n) < d) {
                return n;
            }
            --n;
        }
        return 0;
    }

    protected Queue getQueue() {
        return MonitorManager.getInstance().getDataQueue();
    }
}

