/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.client;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import uk.org.iscream.cms.server.client.Alert;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.XMLPacket;

public class WebFeeder
extends Thread {
    public static final String REVISION = "$Revision: 1.19 $";
    public final int DEFAULT_CHECK_PERIOD = 1800;
    public final int DEFAULT_AGE = 3600;
    private final String sep = File.separator;
    private String _name = "LocalClient";
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    private static WebFeeder _instance;

    public static synchronized WebFeeder getInstance() {
        if (_instance == null) {
            _instance = new WebFeeder();
        }
        return _instance;
    }

    private WebFeeder() {
        ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
        try {
            String string = configurationProxy.getProperty("WebFeeder", "WebFeeder.rootPath");
            String string2 = configurationProxy.getProperty("WebFeeder", "WebFeeder.alertSubDir");
            File file = new File(string, string2);
            if (this.deleteContents(file)) {
                this._logger.write(this.toString(), 5, "Deleted all files and directories from: " + string + this.sep + string2);
            } else {
                this._logger.write(this.toString(), 2, "Failed to delete all files and directories from: " + string + this.sep + string2);
            }
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 1, "Failed to cleanup on construction, due to failing to get config for Alert Data: " + propertyNotFoundException);
        }
        this.setName("client.WebFeeder");
        this.start();
    }

    public void run() {
        boolean bl = true;
        ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
        while (bl) {
            String string;
            String string2;
            int n = 0;
            try {
                n = Integer.parseInt(configurationProxy.getProperty("WebFeeder", "WebFeeder.checkPeriod"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 1800;
                this._logger.write(this.toString(), 2, "Erronous WebFeeder.checkPeriod value in configuration using default of " + n + " seconds");
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                n = 1800;
                this._logger.write(this.toString(), 2, "WebFeeder.checkPeriod value unavailable using default of " + n + " seconds");
            }
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                string2 = configurationProxy.getProperty("WebFeeder", "WebFeeder.rootPath");
                string = configurationProxy.getProperty("WebFeeder", "WebFeeder.alertSubDir");
                String string3 = configurationProxy.getProperty("WebFeeder", "WebFeeder.alertFileName");
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                this._logger.write(this.toString(), 1, "Failed to get config for Alert Data: " + propertyNotFoundException);
                continue;
            }
            int n2 = 0;
            try {
                n2 = Integer.parseInt(configurationProxy.getProperty("WebFeeder", "WebFeeder.alertDeleteOlderThan"));
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 3600;
                this._logger.write(this.toString(), 2, "Erronous WebFeeder.alertDeleteOlderThan value in configuration using default of " + n2 + " seconds");
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                n2 = 3600;
                this._logger.write(this.toString(), 2, "WebFeeder.alertDeleteOlderThan value unavailable using default of " + n2 + " seconds");
            }
            File file = new File(string2, string);
            File[] fileArray = file.listFiles();
            int n3 = 0;
            while (n3 < fileArray.length) {
                File file2 = fileArray[n3];
                if (file2.isDirectory()) {
                    File[] fileArray2;
                    long l = -1L;
                    File[] fileArray3 = file2.listFiles();
                    int n4 = 0;
                    while (n4 < fileArray3.length) {
                        fileArray2 = fileArray3[n4];
                        String string4 = fileArray2.getName();
                        if (string4.endsWith(Alert.alertLevels[0]) || string4.endsWith(Alert.alertLevels[Alert.alertLevels.length - 1])) {
                            long l2 = fileArray2.lastModified();
                            long l3 = System.currentTimeMillis() - l2;
                            if (l3 > (long)n2 * 1000L) {
                                if (string4.endsWith(".HB." + Alert.alertLevels[Alert.alertLevels.length - 1]) && l2 > l) {
                                    l = l2;
                                }
                                if (!fileArray2.delete()) {
                                    this._logger.write(this.toString(), 2, "Failed to delete the following 'old' alert file: " + fileArray2.getPath());
                                }
                            }
                        }
                        ++n4;
                    }
                    if (l >= 0L) {
                        fileArray2 = file2.listFiles();
                        int n5 = 0;
                        while (n5 < fileArray2.length) {
                            File file3 = fileArray2[n5];
                            if (file3.lastModified() < l) {
                                if (file3.delete()) {
                                    this._logger.write(this.toString(), 5, "Deleted stale alert file: " + file3.getPath());
                                } else {
                                    this._logger.write(this.toString(), 2, "Failed to delete the following 'stale' alert file: " + file3.getPath());
                                }
                            }
                            ++n5;
                        }
                    }
                    if ((fileArray2 = file2.listFiles()).length == 0 && !file2.delete()) {
                        this._logger.write(this.toString(), 2, "Failed to delete the following empty host directory: " + file2.getPath());
                    }
                }
                ++n3;
            }
        }
    }

    public void receiveXMLPacket(XMLPacket xMLPacket) {
        String string;
        String string2;
        String string3;
        String string4 = xMLPacket.getParam("packet.attributes.type");
        if (string4 == null || !string4.equals("data")) {
            return;
        }
        ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
        try {
            string3 = configurationProxy.getProperty("WebFeeder", "WebFeeder.rootPath");
            string2 = configurationProxy.getProperty("WebFeeder", "WebFeeder.latestSubDir");
            string = configurationProxy.getProperty("WebFeeder", "WebFeeder.latestFileName");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 1, "Failed to get config for Latest Data: " + propertyNotFoundException);
            return;
        }
        String string5 = xMLPacket.printAll();
        String string6 = xMLPacket.getParam("packet.attributes.machine_name");
        File file = new File(string3, string2 + this.sep + string6);
        File file2 = new File(string3, string2 + this.sep + string6 + this.sep + string);
        this.writeData(file, file2, string5);
    }

    public void receiveAlert(Alert alert) {
        File file;
        String string;
        String string2;
        String string3;
        ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
        try {
            string3 = configurationProxy.getProperty("WebFeeder", "WebFeeder.rootPath");
            string2 = configurationProxy.getProperty("WebFeeder", "WebFeeder.alertSubDir");
            string = configurationProxy.getProperty("WebFeeder", "WebFeeder.alertFileName");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 1, "Failed to get config for Alert Data: " + propertyNotFoundException);
            return;
        }
        String string4 = alert.printAll();
        String string5 = alert.getSource();
        File file2 = new File(string3, string2 + this.sep + string5);
        String string6 = string2 + this.sep + string5 + this.sep + string + "." + String.valueOf(alert.getInitialAlertTime());
        if (alert.getLevel() == 0 || alert.getLevel() == Alert.alertLevels.length - 1) {
            File file3 = new File(string3, string6);
            file = alert.getAttributeName().equals("Heartbeat") && alert.getLevel() == Alert.alertLevels.length - 1 ? new File(string3, string6 + ".HB." + Alert.alertLevels[alert.getLevel()]) : new File(string3, string6 + "." + Alert.alertLevels[alert.getLevel()]);
            if (!file3.renameTo(file)) {
                this._logger.write(this.toString(), 2, "Failed to rename old file, " + file3.getPath() + " to new file, " + file.getPath());
            }
        } else {
            file = new File(string3, string6);
        }
        this.writeData(file2, file, string4);
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), REVISION);
    }

    private void writeData(File file, File file2, String string) {
        if (!file.exists() && !file.mkdirs()) {
            this._logger.write(this.toString(), 1, "Failed to create directory: " + file.getPath());
            return;
        }
        if (!file2.exists()) {
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                this._logger.write(this.toString(), 1, "Failed to create file: " + iOException);
                return;
            }
        }
        if (file2.canWrite()) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
                printWriter.println(string);
                printWriter.close();
            }
            catch (IOException iOException) {
                this._logger.write(this.toString(), 1, "Failed to write file: " + iOException);
            }
        } else {
            this._logger.write(this.toString(), 1, "File not writeable: " + file2.getPath());
        }
    }

    private boolean deleteContents(File file) {
        boolean bl = true;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                File file2 = fileArray[n];
                if (file2.isDirectory()) {
                    bl &= this.deleteContents(file2);
                }
                bl &= file2.delete();
                ++n;
            }
        } else {
            bl = false;
        }
        return bl;
    }
}

