/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.client;

import uk.org.iscream.cms.server.client.Alert;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;

public class Register {
    public static final String REVISION = "$Revision: 1.17 $";
    private String _hostname;
    private String _monitorName;
    private String _attributeName;
    private int _lastAlertLevel;
    private int _lastThresholdLevel;
    private long _lastAlertTimeout;
    private long[] _times;
    private long _initialAlertTime;
    private ConfigurationProxy _cp = ConfigurationProxy.getInstance();
    private int _maxLevelCount = 0;

    public Register(String string, String string2) {
        this(string, string2, null);
    }

    public Register(String string, String string2, String string3) {
        this._hostname = string;
        this._monitorName = string2;
        this._attributeName = string3;
        this._lastAlertLevel = 0;
        this._lastThresholdLevel = 0;
        this._initialAlertTime = 0L;
        this._lastAlertTimeout = 0L;
        this._times = new long[Alert.alertLevels.length];
        int n = 0;
        while (n < Alert.alertLevels.length) {
            this._times[n] = 0L;
            ++n;
        }
    }

    private String getThresholdConfig(int n, String string) throws PropertyNotFoundException {
        String string2 = "";
        if (string != null) {
            string2 = "." + string;
        }
        return this._cp.getProperty("Host." + this._hostname, "Monitor." + this._monitorName + string2 + ".threshold." + Alert.thresholdLevels[n]);
    }

    public int getLastAlertLevel() {
        return this._lastAlertLevel;
    }

    public void setLastThresholdLevel(int n) {
        this._lastThresholdLevel = n;
    }

    public int getLastThresholdLevel() {
        return this._lastThresholdLevel;
    }

    public void setLastAlertLevel(int n) {
        this._lastAlertLevel = n;
        if (n == 0) {
            this._maxLevelCount = 0;
        }
        if (n == 1) {
            this._initialAlertTime = System.currentTimeMillis();
        }
    }

    public long getTimeLastSent() {
        return this._times[this.getLastAlertLevel()];
    }

    public void setTimeLastSent(long l) {
        this._times[this.getLastAlertLevel()] = l;
    }

    public double getThreshold(int n) {
        double d = -1.0;
        try {
            String string = "";
            try {
                string = this.getThresholdConfig(n, this._attributeName);
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                string = this.getThresholdConfig(n, null);
            }
            d = Double.parseDouble(string);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            d = -1.0;
        }
        catch (NumberFormatException numberFormatException) {
            d = -1.0;
        }
        return d;
    }

    public long getAlertTimeout(int n) {
        long l = 0L;
        try {
            String string;
            try {
                string = this._cp.getProperty("Host." + this._hostname, "Monitor." + this._monitorName + ".alertTimeout." + Alert.alertLevels[n]);
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                string = this._cp.getProperty("Host." + this._hostname, "Monitor.alertTimeout." + Alert.alertLevels[n]);
            }
            int n2 = this.getLastThresholdLevel();
            if (n2 > 0) {
                l = Long.parseLong(string) / (long)n2 * 1000L;
            }
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            l = 0L;
        }
        catch (NumberFormatException numberFormatException) {
            l = 0L;
        }
        return l;
    }

    public int getNextAlertLevel() {
        if (this.getLastAlertLevel() + 1 > Alert.alertLevels.length - 2) {
            return this.getLastAlertLevel();
        }
        return this.getLastAlertLevel() + 1;
    }

    public long getLastAlertTimeout() {
        return this._lastAlertTimeout;
    }

    public void setLastAlertTimeout(long l) {
        this._lastAlertTimeout = l;
    }

    public long getInitialAlertTime() {
        return this._initialAlertTime;
    }

    public void escalateAlert() {
        if (this.getLastAlertLevel() != Alert.alertLevels.length - 1) {
            this.setLastAlertLevel(this.getNextAlertLevel());
        }
        try {
            int n = Integer.parseInt(this._cp.getProperty("Host." + this._hostname, "Monitor." + this._monitorName + ".reachFINALcount"));
            if (this.getLastAlertLevel() == Alert.alertLevels.length - 2) {
                ++this._maxLevelCount;
                if (this._maxLevelCount > n) {
                    this.setLastAlertLevel(5);
                }
            }
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

