/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.client;

import org.omg.CORBA.Object;
import org.omg.PortableServer.Servant;
import uk.org.iscream.cms.server.client.AlerterManager;
import uk.org.iscream.cms.server.client.Client;
import uk.org.iscream.cms.server.client.ClientHelper;
import uk.org.iscream.cms.server.client.ClientServant;
import uk.org.iscream.cms.server.client.MonitorManager;
import uk.org.iscream.cms.server.clientinterface.CorbaClientListener;
import uk.org.iscream.cms.server.clientinterface.CorbaClientListenerHelper;
import uk.org.iscream.cms.server.clientinterface.CorbaControlHandler;
import uk.org.iscream.cms.server.componentmanager.Component;
import uk.org.iscream.cms.server.componentmanager.ComponentCORBAException;
import uk.org.iscream.cms.server.componentmanager.ComponentStartException;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.StringUtils;

public class ClientMain
implements Component {
    public static final String REVISION = "$Revision: 1.20 $";
    public static final String NAME = "LocalClient";
    private Logger _logger;
    private ReferenceManager _refman = ReferenceManager.getInstance();
    public static Queue _alerterQueue;
    public static Queue _monitorQueue;

    public void start() throws ComponentStartException {
        java.lang.Object object;
        java.lang.Object object2;
        int n;
        this._logger = this._refman.getLogger();
        this._logger.write(this.toString(), 4, "coming up");
        ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
        try {
            n = Integer.parseInt(configurationProxy.getProperty(NAME, "Queue.SizeLimit"));
            object2 = configurationProxy.getProperty(NAME, "Queue.RemoveAlgorithm");
            int n2 = StringUtils.getStringPos((String)object2, Queue.algorithms);
            if (n2 != -1) {
                this._logger.write(this.toString(), 5, "Starting 2 Queues with size limit of " + n + ", using remove algorithm " + (String)object2);
                _alerterQueue = new Queue(n, n2);
                _monitorQueue = new Queue(n, n2);
            } else {
                this._logger.write(this.toString(), 2, "Bad Queue Algorithm configuration, not known: " + (String)object2);
                _alerterQueue = new Queue();
                _monitorQueue = new Queue();
            }
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 5, "Optional config not set: " + propertyNotFoundException);
            _alerterQueue = new Queue();
            _monitorQueue = new Queue();
        }
        catch (NumberFormatException numberFormatException) {
            this._logger.write(this.toString(), 2, "Bad Queue SizeLimit configuration: " + numberFormatException);
            _alerterQueue = new Queue();
            _monitorQueue = new Queue();
        }
        try {
            n = Integer.parseInt(configurationProxy.getProperty(NAME, "Queue.MonitorInterval"));
            _alerterQueue.startMonitor(n * 1000, _monitorQueue, "LocalClient Alerter");
            _monitorQueue.startMonitor(n * 1000, _monitorQueue, "LocalClient Monitor");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 2, "failed to find queue monitor config, disabling. " + propertyNotFoundException);
        }
        this._logger.write(this.toString(), 4, "starting servant and connecting");
        try {
            object = new ClientServant(_monitorQueue);
            object2 = this._refman.getRootPOA().servant_to_reference((Servant)object);
            Client client = ClientHelper.narrow((Object)object2);
            object2 = this._refman.getCORBARef("iscream.ClientInterface.CorbaListener");
            CorbaClientListener corbaClientListener = CorbaClientListenerHelper.narrow((Object)object2);
            this._logger.write(this.toString(), 4, "connecting");
            CorbaControlHandler corbaControlHandler = corbaClientListener.connect(client, NAME);
            corbaControlHandler.startData();
        }
        catch (Exception exception) {
            this._logger.write(this.toString(), 1, "ERROR - " + exception.getMessage());
        }
        object = MonitorManager.getInstance();
        ((Thread)object).start();
        object2 = AlerterManager.getInstance();
        ((Thread)object2).start();
        this._logger.write(this.toString(), 4, "started");
    }

    public boolean depCheck() {
        try {
            Object object = this._refman.getCORBARef("iscream.ConfigurationManager");
            ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
            String string = configurationProxy.getProperty("RootFilter", "RootFilter.realtimeInterfaceName");
            object = this._refman.getCORBARef("iscream.ClientInterface." + string);
        }
        catch (ComponentCORBAException componentCORBAException) {
            System.err.println(this.toString() + ": Dependency Failure: " + componentCORBAException);
            return false;
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            System.err.println(this.toString() + ": Unable to obtain configuration: " + propertyNotFoundException);
            return false;
        }
        return true;
    }

    public String toString() {
        return FormatName.getName(NAME, this.getClass().getName(), REVISION);
    }
}

