/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.client;

import java.util.LinkedList;
import java.util.StringTokenizer;
import uk.org.iscream.cms.server.client.ClientMain;
import uk.org.iscream.cms.server.client.PluginAlerter;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.Queue;

public class AlerterManager
extends Thread {
    public static final String REVISION = "$Revision: 1.9 $";
    private String _name = "LocalClient";
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    private ReferenceManager _refman = ReferenceManager.getInstance();
    private final String _suffix = "__Alerter";
    private LinkedList _alerterPipeline = new LinkedList();
    private static AlerterManager _instance;

    public static synchronized AlerterManager getInstance() {
        if (_instance == null) {
            _instance = new AlerterManager();
        }
        return _instance;
    }

    private AlerterManager() {
        String string;
        String string2;
        this.setName("client.AlerterManager");
        this._logger.write(this.toString(), 4, "Initialising");
        this._logger.write(this.toString(), 3, "Creating alerter pipeline for plugin alerters ...");
        ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
        try {
            string2 = configurationProxy.getProperty(this._name, "Alerter.PluginsPackage");
            string = configurationProxy.getProperty(this._name, "Alerter.Plugins");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 2, "Unable to get required configuration, Alerter's will not be activated: " + propertyNotFoundException);
            string2 = "";
            string = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = string2 + "." + stringTokenizer.nextToken() + "__Alerter";
            this._logger.write(this.toString(), 5, "Attempting to create plugin: " + string3);
            try {
                PluginAlerter pluginAlerter = (PluginAlerter)ClassLoader.getSystemClassLoader().loadClass(string3).newInstance();
                this._alerterPipeline.add(pluginAlerter);
                this._logger.write(this.toString(), 5, "Added alerter: " + string3 + " (" + pluginAlerter.getDescription() + ")");
            }
            catch (InstantiationException instantiationException) {
                this._logger.write(this.toString(), 1, "Failed to instantiate " + string3 + " to the plugin alerter pipeline.");
                this._logger.write(this.toString(), 1, instantiationException.getMessage());
            }
            catch (Exception exception) {
                this._logger.write(this.toString(), 1, "Failed to add " + string3 + " to the plugin alerter pipeline.");
                this._logger.write(this.toString(), 1, exception.toString());
            }
        }
        this._logger.write(this.toString(), 3, "The alerter pipeline has been set up with " + this._alerterPipeline.size() + " plugin alerters.");
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), REVISION);
    }

    public Queue getQueue() {
        return ClientMain._alerterQueue;
    }
}

