/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.IntType;
import org.jacorb.idl.TypeSpec;

class LongLongType
extends IntType {
    public LongLongType(int n) {
        super(n);
    }

    public Object clone() {
        return new LongLongType(IdlSymbol.new_num());
    }

    public TypeSpec typeSpec() {
        return this;
    }

    public String typeName() {
        return "long";
    }

    public boolean basic() {
        return true;
    }

    public int getTCKind() {
        return 23;
    }

    public String toString() {
        return this.typeName();
    }

    public String holderName() {
        return "org.omg.CORBA.LongHolder";
    }

    public String printReadExpression(String string) {
        return string + ".read_longlong()";
    }

    public String printReadStatement(String string, String string2) {
        return string + "=" + string2 + ".read_longlong();";
    }

    public String printWriteStatement(String string, String string2) {
        return string2 + ".write_longlong(" + string + ");";
    }

    public String printInsertExpression() {
        return "insert_longlong";
    }

    public String printExtractExpression() {
        return "extract_longlong";
    }

    public String signature() {
        return "J";
    }
}

