/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.jacorb.idl.ConstExpr;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.TemplateTypeSpec;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.parser;

class FixedPointType
extends TemplateTypeSpec {
    public ConstExpr digit_expr = null;
    public ConstExpr scale_expr = null;
    private int digits = 0;
    private int scale = 0;

    public FixedPointType(int n) {
        super(n);
    }

    public Object clone() {
        FixedPointType fixedPointType = new FixedPointType(IdlSymbol.new_num());
        fixedPointType.name = this.name;
        fixedPointType.pack_name = this.pack_name;
        fixedPointType.digit_expr = this.digit_expr;
        fixedPointType.digits = this.digits;
        fixedPointType.scale_expr = this.scale_expr;
        fixedPointType.scale = this.scale;
        fixedPointType.included = this.included;
        fixedPointType.typedefd = this.typedefd;
        fixedPointType.set_token(this.get_token());
        fixedPointType.setEnclosingSymbol(this.getEnclosingSymbol());
        return fixedPointType;
    }

    private String helperName() {
        if (this.pack_name.length() > 0) {
            String string = ScopedName.unPseudoName(this.pack_name + "." + this.name);
            if (!string.startsWith("org.omg")) {
                return this.omg_package_prefix + string;
            }
            return string;
        }
        return ScopedName.unPseudoName(this.name);
    }

    public String typeName() {
        return "java.math.BigDecimal";
    }

    public TypeSpec typeSpec() {
        return this;
    }

    public void setEnclosingSymbol(IdlSymbol idlSymbol) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != idlSymbol) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = idlSymbol;
    }

    private void printHelperClass(String string, PrintWriter printWriter) {
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";");
        }
        printWriter.println("public class " + string + "Helper");
        printWriter.println("{");
        printWriter.println("\tprivate static org.omg.CORBA.TypeCode _type = " + this.getTypeCodeExpression() + ";");
        printWriter.println("\tpublic " + string + "Helper ()");
        printWriter.println("\t{");
        printWriter.println("\t}");
        printWriter.println("\tpublic static void insert(org.omg.CORBA.Any any, java.math.BigDecimal s)");
        printWriter.println("\t{");
        printWriter.println("\t\tany.insert_fixed(s, type());");
        printWriter.println("\t}");
        printWriter.println("\tpublic static java.math.BigDecimal extract(org.omg.CORBA.Any any)");
        printWriter.println("\t{");
        printWriter.println("\t\treturn any.extract_fixed();");
        printWriter.println("\t}");
        printWriter.println("\tpublic static org.omg.CORBA.TypeCode type()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn _type;");
        printWriter.println("\t}");
        printWriter.println("\tpublic String get_id()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn id();");
        printWriter.println("\t}");
        printWriter.println("\tpublic org.omg.CORBA.TypeCode get_type()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn type();");
        printWriter.println("\t}");
        printWriter.println("\tpublic void write_Object(org.omg.CORBA.portable.OutputStream out, java.lang.Object obj)");
        printWriter.println("\t{");
        printWriter.println("\t\t throw new RuntimeException(\" not implemented\");");
        printWriter.println("\t}");
        printWriter.println("\tpublic java.lang.Object read_Object(org.omg.CORBA.portable.InputStream in)");
        printWriter.println("\t{");
        printWriter.println("\t\t throw new RuntimeException(\" not implemented\");");
        printWriter.println("\t}");
        this.printIdMethod(printWriter);
        printWriter.println("\tpublic static java.math.BigDecimal read(org.omg.CORBA.portable.InputStream in)");
        printWriter.println("\t{");
        printWriter.println("\t\tjava.math.BigDecimal result = in.read_fixed();");
        printWriter.println("\t\treturn result.movePointLeft(" + this.scale + ");");
        printWriter.println("\t}");
        printWriter.println("\tpublic static void write(org.omg.CORBA.portable.OutputStream out, java.math.BigDecimal s)");
        printWriter.println("\t{");
        StringBuffer stringBuffer = new StringBuffer("1");
        int n = 0;
        while (n < this.digits - this.scale) {
            stringBuffer.append("0");
            ++n;
        }
        printWriter.println("\t\tif( s.scale() != " + this.scale + ")");
        printWriter.println("\t\t\tthrow new org.omg.CORBA.DATA_CONVERSION();");
        printWriter.println("\t\tjava.math.BigDecimal max = new java.math.BigDecimal(\"" + stringBuffer.toString() + "\");");
        printWriter.println("\t\tif( s.compareTo(max) != -1)");
        printWriter.println("\t\t\tthrow new org.omg.CORBA.DATA_CONVERSION();");
        printWriter.println("\t\tout.write_fixed(s);");
        printWriter.println("\t}");
        printWriter.println("}");
    }

    public void print(PrintWriter printWriter) {
        try {
            String string;
            String string2 = this.helperName();
            if (string2.indexOf(46) > 0) {
                this.pack_name = string2.substring(0, string2.lastIndexOf(46));
                string = string2.substring(string2.lastIndexOf(46) + 1);
            } else {
                this.pack_name = "";
                string = string2;
            }
            String string3 = parser.out_dir + IdlSymbol.fileSeparator + this.pack_name.replace('.', IdlSymbol.fileSeparator);
            File file = new File(string3);
            if (!file.exists() && !file.mkdirs()) {
                System.err.println("Unable to create " + string3);
                System.exit(1);
            }
            String string4 = string + "Helper.java";
            PrintWriter printWriter2 = new PrintWriter(new FileWriter(new File(file, string4)));
            this.printHelperClass(string, printWriter2);
            printWriter2.close();
        }
        catch (IOException iOException) {
            System.err.println("File IO error");
            iOException.printStackTrace();
        }
    }

    public void setPackage(String string) {
        string = parser.pack_replace(string);
        this.pack_name = this.pack_name.length() > 0 ? new String(string + "." + this.pack_name) : string;
    }

    public String toString() {
        return this.typeName();
    }

    public String holderName() {
        return "org.omg.CORBA.FixedHolder";
    }

    public String getTypeCodeExpression() {
        return "org.omg.CORBA.ORB.init().create_fixed_tc((short)" + this.digits + ",(short)" + this.scale + ")";
    }

    public String printReadExpression(String string) {
        return this.helperName() + "Helper.read(" + string + ")";
    }

    public String printReadStatement(String string, String string2) {
        String string3 = null;
        string3 = this.hashCode() > 0 ? "_fixed" + this.hashCode() : "_fixed" + -1 * this.hashCode();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t\tjava.math.BigDecimal " + string3 + "=" + string2 + ".read_fixed();\n");
        stringBuffer.append("\t\t" + string + " = " + string3 + ".movePointLeft(" + this.scale + ");\n");
        return stringBuffer.toString();
    }

    public String printWriteStatement(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("1");
        int n = 0;
        while (n < this.digits - this.scale) {
            stringBuffer.append("0");
            ++n;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("\n\t\tif(" + string + ".scale() != " + this.scale + ")\n");
        stringBuffer2.append("\t\t\tthrow new org.omg.CORBA.DATA_CONVERSION(\"wrong scale in fixed point value, expecting " + this.scale + ", got \" + " + string + ".scale() );\n");
        String string3 = null;
        string3 = this.hashCode() > 0 ? "_max" + this.hashCode() : "_max" + -1 * this.hashCode();
        stringBuffer2.append("\t\tjava.math.BigDecimal " + string3 + "= new java.math.BigDecimal(\"" + stringBuffer.toString() + "\");\n");
        stringBuffer2.append("\t\tif( " + string + ".compareTo(" + string3 + " ) != -1)\n");
        stringBuffer2.append("\t\t\tthrow new org.omg.CORBA.DATA_CONVERSION(\"more than " + this.digits + " digits in fixed point value\");\n");
        stringBuffer2.append("\t\t" + string2 + ".write_fixed(" + string + ");\n");
        return stringBuffer2.toString();
    }

    public void parse() {
        this.digits = this.digit_expr.pos_int_const();
        this.scale = this.scale_expr.pos_int_const();
    }
}

