/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jacorb.poa.AOMListener;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.POA;
import org.jacorb.poa.RequestController;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.util.LogTrace;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.poa.util.StringPair;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;

public class AOM {
    private AOMListener aomListener;
    private boolean unique;
    private boolean singleThreaded;
    private LogTrace logTrace;
    private Hashtable objectMap = new Hashtable();
    private Hashtable servantMap;
    private Vector etherealisationList = new Vector();
    private Vector incarnationList = new Vector();

    private AOM() {
    }

    protected AOM(boolean bl, boolean bl2, LogTrace logTrace) {
        this.unique = bl;
        this.singleThreaded = bl2;
        this.logTrace = logTrace;
        if (this.unique) {
            this.servantMap = new Hashtable();
        }
    }

    protected synchronized void add(byte[] byArray, Servant servant) throws ObjectAlreadyActive, ServantAlreadyActive {
        String string = POAUtil.objectId_to_string(byArray);
        while (this.incarnationList.contains(string) || this.etherealisationList.contains(string)) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.objectMap.containsKey(string)) {
            throw new ObjectAlreadyActive();
        }
        if (this.unique && this.servantMap.containsKey(servant)) {
            throw new ServantAlreadyActive();
        }
        this.objectMap.put(string, servant);
        if (this.unique) {
            this.servantMap.put(servant, string);
            Enumeration enumeration = this.servantMap.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
            }
        }
        this.logTrace.printLog(1026, byArray, "object is activated");
        if (this.aomListener != null) {
            this.aomListener.objectActivated(byArray, servant, this.objectMap.size());
        }
    }

    protected synchronized void addAOMListener(AOMListener aOMListener) {
        this.aomListener = EventMulticaster.add(this.aomListener, aOMListener);
    }

    protected boolean contains(byte[] byArray) {
        return this.objectMap.containsKey(POAUtil.objectId_to_string(byArray));
    }

    protected boolean contains(Servant servant) {
        if (this.unique) {
            return this.servantMap.containsKey(servant);
        }
        return this.objectMap.contains(servant);
    }

    protected synchronized StringPair[] deliverContent() {
        StringPair[] stringPairArray = new StringPair[this.objectMap.size()];
        Enumeration enumeration = this.objectMap.keys();
        int n = 0;
        while (n < stringPairArray.length) {
            String string = (String)enumeration.nextElement();
            stringPairArray[n] = new StringPair(string, this.objectMap.get(string).getClass().getName());
            ++n;
        }
        return stringPairArray;
    }

    protected byte[] getObjectId(Servant servant) {
        if (!this.unique) {
            throw new POAInternalError("error: not UNIQUE_ID policy (getObjectId)");
        }
        String string = (String)this.servantMap.get(servant);
        Enumeration enumeration = this.servantMap.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
        }
        if (string != null) {
            return POAUtil.string_to_objectId(string);
        }
        return null;
    }

    protected Servant getServant(byte[] byArray) {
        return (Servant)this.objectMap.get(POAUtil.objectId_to_string(byArray));
    }

    protected synchronized Servant incarnate(byte[] byArray, ServantActivator servantActivator, org.omg.PortableServer.POA pOA) throws ForwardRequest {
        String string = POAUtil.objectId_to_string(byArray);
        Servant servant = null;
        while (!this.incarnationList.isEmpty() || !this.etherealisationList.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.objectMap.containsKey(string)) {
            return (Servant)this.objectMap.get(string);
        }
        this.incarnationList.addElement(string);
        try {
            servant = servantActivator.incarnate(byArray, pOA);
            Object var8_7 = null;
            this.incarnationList.removeElement(string);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.incarnationList.removeElement(string);
            this.notifyAll();
            throw throwable;
        }
        this.notifyAll();
        if (servant == null) {
            this.logTrace.printLog(0, byArray, "servant is not incarnated (incarnate returns null)");
            return null;
        }
        if (this.unique && this.servantMap.containsKey(servant)) {
            this.logTrace.printLog(0, byArray, "servant is not incarnated (unique_id policy is violated)");
            return null;
        }
        this.logTrace.printLog(2, byArray, "servant is incarnated");
        if (this.aomListener != null) {
            this.aomListener.servantIncarnated(byArray, servant);
        }
        try {
            this.add(byArray, servant);
        }
        catch (ObjectAlreadyActive objectAlreadyActive) {
            throw new POAInternalError("error: object already active (AOM.incarnate)");
        }
        catch (ServantAlreadyActive servantAlreadyActive) {
            throw new POAInternalError("error: servant already active (AOM.incarnate)");
        }
        return servant;
    }

    /*
     * Unable to fully structure code
     */
    protected void remove(byte[] var1_1, RequestController var2_2, ServantActivator var3_3, POA var4_4, boolean var5_5) {
        var6_6 = POAUtil.objectId_to_string(var1_1);
        var7_7 = null;
        var8_8 = this;
        synchronized (var8_8) {
            block17: {
                if (this.objectMap.get(var6_6) == null) {
                    return;
                }
                if (var2_2 != null) {
                    var2_2.waitForObjectCompletion(var1_1);
                }
                if ((var7_7 = (Servant)this.objectMap.get(var6_6)) == null) {
                    return;
                }
                var7_7._this_object()._release();
                this.objectMap.remove(var6_6);
                var7_7._set_delegate(null);
                if (this.unique) {
                    this.servantMap.remove(var7_7);
                }
                this.logTrace.printLog(2, var1_1, "object is deactivated");
                if (this.aomListener != null) {
                    this.aomListener.objectDeactivated(var1_1, var7_7, this.objectMap.size());
                }
                if (var3_3 != null) ** GOTO lbl29
                return;
lbl-1000:
                // 1 sources

                {
                    try {
                        this.wait();
                        continue;
                    }
                    catch (InterruptedException var9_9) {
                        // empty catch block
                    }
lbl29:
                    // 3 sources

                    ** while (!this.incarnationList.isEmpty() || !this.etherealisationList.isEmpty())
                }
lbl30:
                // 1 sources

                this.etherealisationList.addElement(var6_6);
                try {
                    block16: {
                        var3_3.etherealize(var1_1, var4_4, var7_7, this.contains(var7_7), var5_5);
                        this.logTrace.printLog(2, var1_1, "servant is etherealized");
                        if (this.aomListener == null) break block16;
                        this.aomListener.servantEtherialized(var1_1, var7_7);
                    }
                    var11_11 = null;
                    this.etherealisationList.removeElement(var6_6);
                }
                catch (Throwable var10_14) {
                    var11_13 = null;
                    this.etherealisationList.removeElement(var6_6);
                    this.notifyAll();
                    throw var10_14;
                }
                this.notifyAll();
                {
                    break block17;
                    catch (SystemException var9_10) {
                        this.logTrace.printLog(1, var1_1, "exception occurred during servant etherialisation: " + var9_10);
                        var11_12 = null;
                        this.etherealisationList.removeElement(var6_6);
                        this.notifyAll();
                    }
                }
            }
            if (var2_2 != null) {
                var2_2.freeObject(var1_1);
            }
        }
    }

    protected void removeAll(ServantActivator servantActivator, POA pOA, boolean bl) {
        Enumeration enumeration = this.objectMap.keys();
        while (enumeration.hasMoreElements()) {
            byte[] byArray = POAUtil.string_to_objectId((String)enumeration.nextElement());
            this.remove(byArray, null, servantActivator, pOA, bl);
        }
    }

    protected synchronized void removeAOMListener(AOMListener aOMListener) {
        this.aomListener = EventMulticaster.remove(this.aomListener, aOMListener);
    }

    protected int size() {
        return this.objectMap.size();
    }

    public void printSizes() {
        System.out.println("AOM: objectMap " + this.size() + " servantMap " + this.servantMap.size());
    }
}

