/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.portableInterceptor.ClientRequestInfoImpl;
import org.jacorb.orb.portableInterceptor.RequestInterceptorIterator;
import org.jacorb.util.Debug;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UserException;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.Interceptor;

public class ClientInterceptorIterator
extends RequestInterceptorIterator {
    public static final short SEND_REQUEST = 0;
    public static final short SEND_POLL = 1;
    public static final short RECEIVE_REPLY = 2;
    public static final short RECEIVE_EXCEPTION = 3;
    public static final short RECEIVE_OTHER = 4;
    private ClientRequestInfoImpl info = null;

    public ClientInterceptorIterator(Interceptor[] interceptorArray) {
        super(interceptorArray);
    }

    public void iterate(ClientRequestInfoImpl clientRequestInfoImpl, short s) throws UserException {
        this.info = clientRequestInfoImpl;
        this.op = s;
        this.setDirection(s == 0 || s == 1);
        this.iterate();
        if (this.interceptor_ex != null) {
            if (this.interceptor_ex instanceof ForwardRequest) {
                throw (ForwardRequest)this.interceptor_ex;
            }
            throw (SystemException)this.interceptor_ex;
        }
    }

    protected void invoke(Interceptor interceptor) throws UserException {
        this.info.caller_op = this.op;
        try {
            Debug.output(16386, "Invoking CI " + interceptor.name());
            switch (this.op) {
                case 0: {
                    ((ClientRequestInterceptor)interceptor).send_request(this.info);
                    break;
                }
                case 1: {
                    ((ClientRequestInterceptor)interceptor).send_poll(this.info);
                    break;
                }
                case 2: {
                    ((ClientRequestInterceptor)interceptor).receive_reply(this.info);
                    break;
                }
                case 3: {
                    ((ClientRequestInterceptor)interceptor).receive_exception(this.info);
                    break;
                }
                case 4: {
                    ((ClientRequestInterceptor)interceptor).receive_other(this.info);
                }
            }
        }
        catch (ForwardRequest forwardRequest) {
            Debug.output(16386, forwardRequest);
            this.reverseDirection();
            this.op = (short)4;
            this.info.reply_status = forwardRequest.permanent ? (short)4 : (short)3;
            this.info.forward_reference = forwardRequest.forward;
            this.interceptor_ex = forwardRequest;
        }
        catch (SystemException systemException) {
            Debug.output(16386, systemException);
            this.reverseDirection();
            this.op = (short)3;
            this.interceptor_ex = systemException;
            SystemExceptionHelper.insert(this.info.received_exception, systemException);
            try {
                this.info.received_exception_id = SystemExceptionHelper.type(systemException).id();
            }
            catch (BadKind badKind) {
                Debug.output(16386, badKind);
            }
        }
        catch (Throwable throwable) {
            Debug.output(16385, "ClientInterceptorIterator: Caught a " + throwable);
        }
        this.info.caller_op = this.op;
    }
}

