/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.domain;

import java.util.Hashtable;
import org.jacorb.orb.domain.ConflictResolutionPolicyOperations;
import org.jacorb.orb.domain.ConflictResolutionPolicyPOATie;
import org.jacorb.orb.domain.Domain;
import org.jacorb.orb.domain.DomainImpl;
import org.jacorb.orb.domain.DomainOperations;
import org.jacorb.orb.domain.ManagementPolicyImpl;
import org.jacorb.util.Debug;
import org.omg.CORBA.Policy;

public class ParentRulesPolicy
extends ManagementPolicyImpl
implements ConflictResolutionPolicyOperations {
    public ParentRulesPolicy() {
        super("conflict resolve");
        String string = "This object implements the domain conflict resolving policy. The conflict resolving policy decides which domain/policy in the case of overlapping domains to use. This policy gives precedence to the domain which is the highest domain (nearest to the common root domain) in the list of conflicting domains. Simplified to the case of two conflicting domains which are in a parent-child relationship this means the parent domain takes precedence. If there is no such unique domain (which is possible, but should not be the case, because then all the conflictiong domains do not have anything in common and should therefore not conflict) then the first domain of the list is taken.";
        this.long_description(string);
    }

    public Policy resolveConflict(Domain[] domainArray, int n) {
        Debug.assert(1, domainArray.length > 0, "SimpleConflictResolutionPolicy: list of overlapping domain managers is empty");
        if (domainArray.length == 2) {
            if (domainArray[0].isReachable(domainArray[1])) {
                return domainArray[0].get_domain_policy(n);
            }
            if (domainArray[1].isReachable(domainArray[0])) {
                return domainArray[1].get_domain_policy(n);
            }
            return domainArray[0].get_domain_policy(n);
        }
        Domain domain = DomainImpl.getRootDomain(domainArray[0], new Hashtable());
        Hashtable hashtable = DomainImpl.calculateDistances(domain);
        int n2 = Integer.MAX_VALUE;
        DomainOperations domainOperations = null;
        int n3 = 0;
        int n4 = 0;
        while (n4 < domainArray.length) {
            n3 = (Integer)hashtable.get(domainArray[n4]);
            Debug.output(4, "ParentRules.resolveConflict: distance of " + domainArray[n4].name() + " to root " + domain.name() + " is " + n3);
            if (n3 < n2) {
                n2 = n3;
                domainOperations = domainArray[n4];
            }
            ++n4;
        }
        Debug.output(3, "ParentRules.resolveConflict: chosen " + domainOperations.name() + " with distance " + n2 + " to domain " + domain.name());
        return domainOperations.get_domain_policy(n);
    }

    public int[] managedTypes() {
        int[] nArray = new int[]{0};
        return nArray;
    }

    public void setPolicyType(int n) {
    }

    public short strategy() {
        return 2;
    }

    public int policy_type() {
        return 114;
    }

    public Policy copy() {
        return new ConflictResolutionPolicyPOATie(new ParentRulesPolicy())._this();
    }
}

