/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.domain;

import java.util.Enumeration;
import java.util.Hashtable;
import org.jacorb.orb.domain.Domain;
import org.jacorb.orb.domain.DomainImpl;
import org.jacorb.orb.domain.DomainListHolder;
import org.jacorb.orb.domain.ODMCache;
import org.jacorb.orb.domain.ORBDomainOperations;
import org.jacorb.orb.domain.ORBDomainPOATie;
import org.jacorb.util.Debug;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.POA;

public class ORBDomainImpl
extends DomainImpl
implements ORBDomainOperations {
    private ORBDomainPOATie theTie = null;
    private ODMCache theCache;
    private Hashtable theLocalDomains = new Hashtable(30);

    public ORBDomainImpl() {
        this(null, null, "");
    }

    public ORBDomainImpl(Object[] objectArray) {
        this(objectArray, null, "");
    }

    public ORBDomainImpl(Object[] objectArray, Policy[] policyArray) {
        this(objectArray, policyArray, "");
    }

    public ORBDomainImpl(Object[] objectArray, Policy[] policyArray, String string) {
        super(objectArray, policyArray, string);
        this.theCache = new ODMCache();
    }

    public void insertLocalDomain(Domain domain) {
        this.theLocalDomains.put(domain, domain);
    }

    public boolean isLocalTo(Domain domain) {
        return this.theLocalDomains.contains(domain);
    }

    public void removeLocalDomain(Domain domain) {
        this.theLocalDomains.remove(domain);
    }

    public void setTie(ORBDomainPOATie oRBDomainPOATie) {
        this.theTie = oRBDomainPOATie;
    }

    public Domain _this() {
        Debug.output(32771, "ORBDomainImpl._this()");
        Debug.assert(1, this.theTie != null, "ORBDomainPOATie._this: the tie has not been set (is null)");
        return this.theTie._this();
    }

    public POA _getPOA() {
        Debug.assert(1, this.theTie != null, "ORBDomainPOATie._getPOA: the tie has not been set (is null)");
        return this.theTie._poa();
    }

    public ORB _getORB() {
        Debug.assert(1, this.theTie != null, "ORBDomainPOATie._getORB: the tie has not been set (is null)");
        return this.theTie._orb();
    }

    public Domain[] getDomains(Object object) {
        Domain[] domainArray = this.theCache.read(object);
        if (domainArray != null) {
            Debug.output(32771, " ORBDomainImpl<" + this.name() + ">.getDomains: cache hit");
            return domainArray;
        }
        Debug.output(32771, "ORBDomainImpl<" + this.name() + ">.getDomains: cache miss");
        Enumeration enumeration = this.theLocalDomains.keys();
        while (enumeration.hasMoreElements()) {
            Domain domain = (Domain)enumeration.nextElement();
            if (!domain.hasMember(object)) continue;
            Debug.output(32771, " ORBDomainImpl<" + this.name() + ">.getDomains: found mapping for an obj in " + domain.name());
            domainArray = domain.getMapping(object);
            this.theCache.write(object, domainArray);
            return domainArray;
        }
        Debug.output(32771, " ORBDomainImpl<" + this.name() + ">.getDomains: mapping not found in local domains, searching root");
        DomainListHolder domainListHolder = new DomainListHolder();
        if (DomainImpl.traverseDownwards(object, this.getRootDomain(), domainListHolder, new Hashtable())) {
            this.theCache.write(object, domainListHolder.value);
            return domainListHolder.value;
        }
        Debug.output(32771, " ORBDomainImpl<" + this.name() + ">.getDomains: nothing found, returning empty list");
        return new Domain[0];
    }

    public void updateODMCache(Object object, Domain[] domainArray) {
        this.theCache.write(object, domainArray);
    }

    public void invalidateODMCache(Object object) {
        this.theCache.remove(object);
    }

    public void addToODMCache(Object object, Domain domain) {
        this.theCache.writeAddDomain(object, domain);
    }

    public void removeFromODMCache(Object object, Domain domain) {
        this.theCache.writeRemoveDomain(object, domain);
    }
}

