/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.domain;

import java.util.Enumeration;
import java.util.Hashtable;
import org.jacorb.orb.domain.Domain;
import org.jacorb.orb.domain.DomainHelper;
import org.jacorb.orb.domain.ODMCacheEntry;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.Object;

public class ODMCache {
    private Hashtable theDomainLists = new Hashtable();

    public Domain[] read(Object object) {
        Object object2 = object;
        synchronized (object2) {
            java.lang.Object v = this.theDomainLists.get(object);
            if (v == null) {
                Domain[] domainArray = null;
                return domainArray;
            }
            ODMCacheEntry oDMCacheEntry = (ODMCacheEntry)v;
            if (System.currentTimeMillis() - oDMCacheEntry.timestamp > Environment.LifetimeOfCacheEntry()) {
                Domain[] domainArray = null;
                return domainArray;
            }
            if (oDMCacheEntry.domainArray != null) {
                Domain[] domainArray = oDMCacheEntry.domainArray;
                return domainArray;
            }
            oDMCacheEntry.domainArray = new Domain[oDMCacheEntry.group.size()];
            Enumeration enumeration = oDMCacheEntry.group.keys();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                oDMCacheEntry.domainArray[n] = DomainHelper.narrow((Object)enumeration.nextElement());
                Debug.assert(0, oDMCacheEntry.domainArray[n] != null, "OMDCache.read: result " + n + " is null.");
                ++n;
            }
            Domain[] domainArray = oDMCacheEntry.domainArray;
            return domainArray;
        }
    }

    public void write(Object object, Domain[] domainArray) {
        Object object2 = object;
        synchronized (object2) {
            java.lang.Object v = this.theDomainLists.get(object);
            if (v == null) {
                Hashtable<Domain, Domain> hashtable = new Hashtable<Domain, Domain>(domainArray.length);
                int n = 0;
                while (n < domainArray.length) {
                    hashtable.put(domainArray[n], domainArray[n]);
                    ++n;
                }
                this.theDomainLists.put(object, new ODMCacheEntry(hashtable, System.currentTimeMillis()));
            } else {
                ODMCacheEntry oDMCacheEntry = (ODMCacheEntry)v;
                int n = 0;
                while (n < domainArray.length) {
                    oDMCacheEntry.group.put(domainArray[n], domainArray[n]);
                    ++n;
                }
                oDMCacheEntry.domainArray = null;
                oDMCacheEntry.timestamp = System.currentTimeMillis();
            }
        }
    }

    public void writeAddDomain(Object object, Domain domain) {
        Object object2 = object;
        synchronized (object2) {
            java.lang.Object v = this.theDomainLists.get(object);
            if (v == null) {
                Hashtable<Domain, Domain> hashtable = new Hashtable<Domain, Domain>(10);
                hashtable.put(domain, domain);
                this.theDomainLists.put(object, new ODMCacheEntry(hashtable, System.currentTimeMillis()));
            } else {
                ODMCacheEntry oDMCacheEntry = (ODMCacheEntry)v;
                oDMCacheEntry.group.put(domain, domain);
                oDMCacheEntry.domainArray = null;
                oDMCacheEntry.timestamp = System.currentTimeMillis();
            }
        }
    }

    public void writeRemoveDomain(Object object, Domain domain) {
        Object object2 = object;
        synchronized (object2) {
            java.lang.Object v = this.theDomainLists.get(object);
            if (v != null) {
                ODMCacheEntry oDMCacheEntry = (ODMCacheEntry)v;
                oDMCacheEntry.group.remove(domain);
                oDMCacheEntry.domainArray = null;
                oDMCacheEntry.timestamp = System.currentTimeMillis();
            }
        }
    }

    public void remove(Object object) {
        Object object2 = object;
        synchronized (object2) {
            this.theDomainLists.remove(object);
        }
    }

    public void clear() {
        this.theDomainLists.clear();
    }
}

