/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.domain;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import org.jacorb.orb.domain.Domain;
import org.jacorb.orb.domain.DomainFactory;
import org.jacorb.orb.domain.DomainFactoryHelper;
import org.jacorb.orb.domain.DomainFactoryImpl;
import org.jacorb.orb.domain.DomainHelper;
import org.jacorb.orb.domain.GraphNodePackage.ClosesCycle;
import org.jacorb.orb.domain.PolicyFactory;
import org.jacorb.orb.domain.PolicyFactoryHelper;
import org.jacorb.orb.domain.PolicyFactoryImpl;
import org.jacorb.util.Debug;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Policy;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class DomainServer {
    private static void usage() {
        System.err.println("Usage: java org.jacorb.orb.domain.DomainServer <ior_filename>");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            DomainServer.usage();
        }
        String string = stringArray[0];
        Debug.output(32770, "starting domain server ... ");
        Properties properties = new Properties();
        ((Hashtable)properties).put("jacorb.orb_domain.mount", "off");
        ((Hashtable)properties).put("jacorb.use_domain", "on");
        ORB oRB = ORB.init(stringArray, properties);
        try {
            Object object;
            POA pOA = POAHelper.narrow(oRB.resolve_initial_references("RootPOA"));
            pOA.the_POAManager().activate();
            DomainFactoryImpl domainFactoryImpl = new DomainFactoryImpl();
            DomainFactory domainFactory = DomainFactoryHelper.narrow(pOA.servant_to_reference(domainFactoryImpl));
            PolicyFactoryImpl policyFactoryImpl = new PolicyFactoryImpl();
            PolicyFactory policyFactory = PolicyFactoryHelper.narrow(pOA.servant_to_reference(policyFactoryImpl));
            Policy[] policyArray = new Policy[]{policyFactory.createConflictResolutionPolicy((short)2)};
            Domain domain = domainFactory.createDomain(null, policyArray, "domain server");
            Debug.output(32770, "writing IOR of domain service to file " + string);
            try {
                object = new FileOutputStream(stringArray[0]);
                PrintWriter printWriter = new PrintWriter((OutputStream)object);
                printWriter.println(oRB.object_to_string(domain));
                printWriter.flush();
                ((FileOutputStream)object).close();
            }
            catch (IOException iOException) {
                System.err.println("Unable to write IOR to file " + stringArray[0]);
                System.exit(1);
            }
            try {
                object = NamingContextExtHelper.narrow(oRB.resolve_initial_references("NameService"));
                object.bind(object.to_name("Domain.service"), domain);
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                Debug.output(32769, " name server not available,  don't register at name server, but continue.");
            }
            object = DomainHelper.narrow(oRB.resolve_initial_references("LocalDomainService"));
            object.name("domain server orb domain");
            try {
                domain.insertChild((Domain)object);
            }
            catch (ClosesCycle closesCycle) {}
        }
        catch (Exception exception) {
            Debug.output(1, exception);
        }
        Debug.output(32770, "domain server up.");
        oRB.run();
    }
}

