/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection;

import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.net.Socket;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.connection.CodeSet;
import org.jacorb.orb.connection.ConnectionManager;
import org.jacorb.orb.connection.Messages;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.IIOP.Version;
import org.omg.IOP.ServiceContext;

public abstract class AbstractConnection {
    protected InputStream in_stream;
    BufferedOutputStream out_stream;
    public ORB orb;
    protected ConnectionManager manager;
    public int TCS = 0;
    public int TCSW = 0;
    private boolean tcsNegotiated = false;
    public Version IIOPVersion = new Version(1, 0);
    protected int client_count = 0;
    protected Socket mysock = null;
    private byte[] header = new byte[Messages.MSG_HEADER_SIZE];

    public void markTcsNegotiated() {
        if (this.tcsNegotiated) {
            return;
        }
        this.tcsNegotiated = true;
        Debug.output(4, "TCS marked as negotiated");
    }

    public boolean isTCSNegotiated() {
        return this.tcsNegotiated;
    }

    public Socket getSocket() {
        return this.mysock;
    }

    protected int selectCodeSet(CodeSetComponent codeSetComponent, int n) {
        if (codeSetComponent.native_code_set == n) {
            return n;
        }
        int n2 = 0;
        while (n2 < codeSetComponent.conversion_code_sets.length) {
            if (codeSetComponent.conversion_code_sets[n2] == n) {
                return n;
            }
            ++n2;
        }
        return 0;
    }

    protected boolean selectCodeSet(ParsedIOR parsedIOR) {
        int n = 0;
        while (n < parsedIOR.taggedComponents.length) {
            if (parsedIOR.taggedComponents[n].tag == 1) {
                Debug.output(4, "TAG_CODE_SETS found");
                CDRInputStream cDRInputStream = new CDRInputStream(this.orb, parsedIOR.taggedComponents[n].component_data);
                cDRInputStream.setLittleEndian(cDRInputStream.read_boolean());
                CodeSetComponentInfo codeSetComponentInfo = CodeSetComponentInfoHelper.read(cDRInputStream);
                this.TCS = this.selectCodeSet(codeSetComponentInfo.ForCharData, 0x5010001);
                if (this.TCS == 0) {
                    this.TCS = 65537;
                }
                this.TCSW = this.selectCodeSet(codeSetComponentInfo.ForWcharData, 0x5010001);
                if (this.TCSW == 0) {
                    this.TCSW = this.selectCodeSet(codeSetComponentInfo.ForWcharData, 65801);
                }
                Debug.output(4, "TCS selected: " + CodeSet.csName(this.TCS) + "," + CodeSet.csName(this.TCSW));
                return true;
            }
            ++n;
        }
        this.TCS = 65537;
        this.TCSW = 65801;
        this.markTcsNegotiated();
        Debug.output(4, "default TCS selected: " + CodeSet.csName(this.TCS) + "," + CodeSet.csName(this.TCSW));
        return false;
    }

    public boolean setServerCodeSet(ServiceContext[] serviceContextArray) {
        if (!Environment.charsetScanCtx()) {
            return false;
        }
        int n = 0;
        while (n < serviceContextArray.length) {
            if (serviceContextArray[n].context_id == 1) {
                CDRInputStream cDRInputStream = new CDRInputStream(this.orb, serviceContextArray[n].context_data);
                cDRInputStream.setLittleEndian(cDRInputStream.read_boolean());
                CodeSetContext codeSetContext = CodeSetContextHelper.read(cDRInputStream);
                this.TCSW = codeSetContext.wchar_data;
                this.TCS = codeSetContext.char_data;
                this.markTcsNegotiated();
                Debug.output(4, "TCS set: " + CodeSet.csName(this.TCS) + "," + CodeSet.csName(this.TCSW));
                return true;
            }
            ++n;
        }
        return false;
    }

    public ServiceContext[] addCodeSetContext(ServiceContext[] serviceContextArray, ParsedIOR parsedIOR) {
        if (this.tcsNegotiated || !Environment.charsetSendCtx()) {
            return serviceContextArray;
        }
        if (this.TCS == 0 && !this.selectCodeSet(parsedIOR)) {
            return serviceContextArray;
        }
        CDROutputStream cDROutputStream = new CDROutputStream(this.orb);
        cDROutputStream.write_boolean(false);
        CodeSetContextHelper.write(cDROutputStream, new CodeSetContext(this.TCS, this.TCSW));
        ServiceContext[] serviceContextArray2 = new ServiceContext[serviceContextArray.length + 1];
        System.arraycopy(serviceContextArray, 0, serviceContextArray2, 0, serviceContextArray.length);
        serviceContextArray2[serviceContextArray.length] = new ServiceContext(1, cDROutputStream.getBufferCopy());
        return serviceContextArray2;
    }

    public boolean connected() {
        return this.mysock != null;
    }

    public BufferedOutputStream get_out_stream() {
        return this.out_stream;
    }
}

