/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import org.jacorb.imr.util.ImRManager;
import org.jacorb.naming.NamingContextImpl;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivatorPOA;

public class NameServer {
    private static ORB orb = null;
    public static String name_delimiter = "/";
    private static String filePrefix = "_nsdb";

    private static void usage() {
        System.err.println("Usage: java org.jacorb.naming.NameServer <ior_filename> [ <time_out> [imr_register] ]");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        try {
            java.lang.Object object;
            int n = 0;
            if (stringArray.length < 1) {
                NameServer.usage();
            }
            if (stringArray.length >= 2) {
                try {
                    n = Integer.parseInt(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    NameServer.usage();
                }
            }
            Properties properties = new Properties();
            ((Hashtable)properties).put("jacorb.implname", "StandardNS");
            ((Hashtable)properties).put("jacorb.orb_domain.mount", "off");
            String string = Environment.getProperty("jacorb.naming.db_dir");
            if (string != null) {
                filePrefix = string + File.separatorChar + filePrefix;
            }
            orb = ORB.init(stringArray, properties);
            if (Environment.useImR() && stringArray.length == 3 && stringArray[2].equals("imr_register")) {
                object = Environment.getProperty("jacorb.java_exec") + " org.jacorb.naming.NameServer " + stringArray[0] + " " + stringArray[1];
                ImRManager.autoRegisterServer(orb, "StandardNS", (String)object, ImRManager.getLocalHostName(), true);
            }
            object = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
            ((org.jacorb.orb.ORB)orb).getBasicAdapter().setTimeout(30000);
            Policy[] policyArray = new Policy[]{object.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), object.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), object.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER)};
            POA pOA = object.create_POA("NameServer-POA", object.the_POAManager(), policyArray);
            NameServantActivatorImpl nameServantActivatorImpl = new NameServantActivatorImpl(orb);
            pOA.set_servant_manager(nameServantActivatorImpl._this(orb));
            pOA.the_POAManager().activate();
            int n2 = 0;
            while (n2 < policyArray.length) {
                policyArray[n2].destroy();
                ++n2;
            }
            byte[] byArray = new String("_root").getBytes();
            try {
                Object object2 = pOA.create_reference_with_id(byArray, "IDL:omg.org/CosNaming/NamingContextExt:1.0");
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(stringArray[0]), true);
                printWriter.println(orb.object_to_string(object2));
                printWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException(exception.getMessage());
            }
            Debug.output(2, "NS up");
            if (n == 0) {
                orb.run();
            } else {
                Thread.sleep(n);
            }
            orb.shutdown(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    static class NameServantActivatorImpl
    extends ServantActivatorPOA {
        private ORB orb = null;

        public NameServantActivatorImpl(ORB oRB) {
            this.orb = oRB;
        }

        public Servant incarnate(byte[] byArray, POA pOA) throws ForwardRequest {
            String string = new String(byArray);
            NamingContextImpl namingContextImpl = null;
            try {
                File file = new File(filePrefix + string);
                if (file.exists()) {
                    Debug.output(2, "Reading in  context state from file");
                    FileInputStream fileInputStream = new FileInputStream(file);
                    if (fileInputStream.available() > 0) {
                        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                        namingContextImpl = (NamingContextImpl)objectInputStream.readObject();
                        objectInputStream.close();
                    }
                    fileInputStream.close();
                } else {
                    Debug.output(2, "No naming context state, starting empty");
                }
            }
            catch (IOException iOException) {
                Debug.output(2, "File seems corrupt, starting empty");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Could not read object from file, class not found!");
                System.exit(1);
            }
            if (namingContextImpl == null) {
                namingContextImpl = new NamingContextImpl();
            }
            namingContextImpl.init(this.orb, pOA);
            return namingContextImpl;
        }

        public void etherealize(byte[] byArray, POA pOA, Servant servant, boolean bl, boolean bl2) {
            String string = new String(byArray);
            try {
                File file = new File(filePrefix + string);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject((NamingContextImpl)servant);
                Debug.output(2, "Saved state for servant " + string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.err.println("Error opening output file " + filePrefix + string);
            }
        }
    }
}

