/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr;

import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jacorb.imr.AdminPackage.DuplicateServerName;
import org.jacorb.imr.HostInfo;
import org.jacorb.imr.ImRHostInfo;
import org.jacorb.imr.ImRPOAInfo;
import org.jacorb.imr.ImRServerInfo;
import org.jacorb.imr.POAInfo;
import org.jacorb.imr.RessourceLock;
import org.jacorb.imr.ServerInfo;
import org.jacorb.imr.UnknownServerName;
import org.jacorb.util.Environment;

public class ServerTable
implements Serializable {
    private Hashtable servers;
    private transient RessourceLock servers_lock;
    private Hashtable poas;
    private transient RessourceLock poas_lock;
    private Hashtable hosts;
    private transient RessourceLock hosts_lock;
    public transient RessourceLock table_lock;

    public ServerTable() {
        int n = 100;
        int n2 = 5;
        try {
            n = Integer.parseInt(Environment.getProperty("jacorb.imr.no_of_poas"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n2 = Integer.parseInt(Environment.getProperty("jacorb.imr.no_of_servers"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.servers = new Hashtable((int)(1.3333333333333333 * (double)n2));
        this.poas = new Hashtable((int)(1.3333333333333333 * (double)n));
        this.hosts = new Hashtable();
        this.initTransient();
    }

    private void initTransient() {
        this.table_lock = new RessourceLock();
        this.servers_lock = new RessourceLock();
        this.poas_lock = new RessourceLock();
        this.hosts_lock = new RessourceLock();
    }

    public ImRServerInfo getServer(String string) throws UnknownServerName {
        ImRServerInfo imRServerInfo = (ImRServerInfo)this.servers.get(string);
        if (imRServerInfo == null) {
            throw new UnknownServerName(string);
        }
        return imRServerInfo;
    }

    public void putServer(String string, ImRServerInfo imRServerInfo) throws DuplicateServerName {
        if (this.servers.containsKey(string)) {
            throw new DuplicateServerName(string);
        }
        this.table_lock.gainSharedLock();
        this.servers_lock.gainSharedLock();
        this.servers.put(string, imRServerInfo);
        this.servers_lock.releaseSharedLock();
        this.table_lock.releaseSharedLock();
    }

    public void removeServer(String string) throws UnknownServerName {
        this.table_lock.gainSharedLock();
        this.servers_lock.gainSharedLock();
        Object v = this.servers.remove(string);
        this.servers_lock.releaseSharedLock();
        this.table_lock.releaseSharedLock();
        if (v == null) {
            throw new UnknownServerName(string);
        }
    }

    public ImRPOAInfo getPOA(String string) {
        return (ImRPOAInfo)this.poas.get(string);
    }

    public void putPOA(String string, ImRPOAInfo imRPOAInfo) {
        this.table_lock.gainSharedLock();
        this.poas_lock.gainSharedLock();
        this.poas.put(string, imRPOAInfo);
        this.poas_lock.releaseSharedLock();
        this.table_lock.releaseSharedLock();
    }

    public void removePOA(String string) {
        this.table_lock.gainSharedLock();
        this.poas_lock.gainSharedLock();
        this.poas.remove(string);
        this.poas_lock.releaseSharedLock();
        this.table_lock.releaseSharedLock();
    }

    public ServerInfo[] getServers() {
        this.table_lock.gainSharedLock();
        this.servers_lock.gainExclusiveLock();
        ServerInfo[] serverInfoArray = new ServerInfo[this.servers.size()];
        Enumeration enumeration = this.servers.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            serverInfoArray[n++] = ((ImRServerInfo)enumeration.nextElement()).toServerInfo();
        }
        this.servers_lock.releaseExclusiveLock();
        this.table_lock.releaseSharedLock();
        return serverInfoArray;
    }

    public HostInfo[] getHosts() {
        this.table_lock.gainSharedLock();
        this.hosts_lock.gainExclusiveLock();
        HostInfo[] hostInfoArray = new HostInfo[this.hosts.size()];
        Enumeration enumeration = this.hosts.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            hostInfoArray[n++] = ((ImRHostInfo)enumeration.nextElement()).toHostInfo();
        }
        this.hosts_lock.releaseExclusiveLock();
        this.table_lock.releaseSharedLock();
        return hostInfoArray;
    }

    public POAInfo[] getPOAs() {
        this.table_lock.gainSharedLock();
        this.poas_lock.gainExclusiveLock();
        POAInfo[] pOAInfoArray = new POAInfo[this.poas.size()];
        Enumeration enumeration = this.poas.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            pOAInfoArray[n++] = ((ImRPOAInfo)enumeration.nextElement()).toPOAInfo();
        }
        this.poas_lock.releaseExclusiveLock();
        this.table_lock.releaseSharedLock();
        return pOAInfoArray;
    }

    public void putHost(String string, ImRHostInfo imRHostInfo) {
        this.table_lock.gainSharedLock();
        this.hosts_lock.gainSharedLock();
        this.hosts.put(string, imRHostInfo);
        this.hosts_lock.releaseSharedLock();
        this.table_lock.releaseSharedLock();
    }

    public Object removeHost(String string) {
        return this.hosts.remove(string);
    }

    public ImRHostInfo getHost(String string) {
        return (ImRHostInfo)this.hosts.get(string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, NotActiveException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initTransient();
    }
}

