/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.rootfilter;

import org.omg.CORBA.Object;
import uk.org.iscream.cms.server.clientinterface.ClientInterface;
import uk.org.iscream.cms.server.clientinterface.ClientInterfaceHelper;
import uk.org.iscream.cms.server.componentmanager.Component;
import uk.org.iscream.cms.server.componentmanager.ComponentCORBAException;
import uk.org.iscream.cms.server.componentmanager.ComponentStartException;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.rootfilter.CIWrapper;
import uk.org.iscream.cms.server.rootfilter.RootFilterServant;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.StringUtils;

public class RootFilter
implements Component {
    public static final String REVISION = "$Revision: 1.38 $";
    private Logger _logger;
    private ReferenceManager _refman = ReferenceManager.getInstance();
    public static String NAME;

    public void start() throws ComponentStartException {
        Queue queue;
        String string;
        int n;
        String string2;
        String string3;
        this._logger = this._refman.getLogger();
        this._logger.write(this.toString(), 4, "coming up");
        ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
        String string4 = "RootFilter";
        try {
            NAME = configurationProxy.getProperty(string4, "RootFilter.name");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            NAME = null;
            this._logger.write(this.toString(), 2, "RootFilter name not set: " + propertyNotFoundException);
        }
        try {
            string3 = configurationProxy.getProperty(string4, "RootFilter.realtimeInterfaceName");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 5, "Optional config not set: " + propertyNotFoundException);
            string3 = null;
        }
        try {
            string2 = configurationProxy.getProperty(string4, "RootFilter.dbInterfaceName");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 5, "Optional config not set: " + propertyNotFoundException);
            string2 = null;
        }
        ClientInterface clientInterface = null;
        ClientInterface clientInterface2 = null;
        if (string3 != null) {
            clientInterface = ClientInterfaceHelper.narrow(this._refman.getCORBARef("iscream.ClientInterface." + string3));
        }
        if (string2 != null) {
            clientInterface2 = ClientInterfaceHelper.narrow(this._refman.getCORBARef("iscream.ClientInterface." + string2));
        }
        try {
            n = Integer.parseInt(configurationProxy.getProperty(string4, "Queue.SizeLimit"));
            string = configurationProxy.getProperty(string4, "Queue.RemoveAlgorithm");
            int n2 = StringUtils.getStringPos(string, Queue.algorithms);
            if (n2 != -1) {
                this._logger.write(this.toString(), 5, "Starting Queue with size limit of " + n + ", using remove algorithm " + string);
                queue = new Queue(n, n2);
            } else {
                this._logger.write(this.toString(), 2, "Bad Queue Algorithm configuration, not known: " + string);
                queue = new Queue();
            }
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 5, "Optional config not set: " + propertyNotFoundException);
            queue = new Queue();
        }
        catch (NumberFormatException numberFormatException) {
            this._logger.write(this.toString(), 2, "Bad Queue SizeLimit configuration: " + numberFormatException);
            queue = new Queue();
        }
        try {
            n = Integer.parseInt(configurationProxy.getProperty(string4, "Queue.MonitorInterval"));
            string = NAME + " RootFilter";
            queue.startMonitor(n * 1000, string);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 2, "failed to find queue monitor config, disabling. " + propertyNotFoundException);
        }
        if (string3 != null && string2 != null) {
            this._logger.write(this.toString(), 5, "hooked to interfaces - " + string3 + " & " + string2);
            CIWrapper cIWrapper = new CIWrapper(clientInterface, queue);
            cIWrapper.start();
            cIWrapper = new CIWrapper(clientInterface2, queue);
            cIWrapper.start();
        } else if (string3 == null) {
            this._logger.write(this.toString(), 5, "hooked to interfaces - " + string2);
            CIWrapper cIWrapper = new CIWrapper(clientInterface2, queue);
            cIWrapper.start();
        } else if (string2 == null) {
            this._logger.write(this.toString(), 5, "hooked to interfaces - " + string3);
            CIWrapper cIWrapper = new CIWrapper(clientInterface, queue);
            cIWrapper.start();
        } else {
            this._logger.write(this.toString(), 2, "not hooked to any client interfaces, this is probably not intentional!");
        }
        this._logger.write(this.toString(), 5, "starting Root Filter");
        RootFilterServant rootFilterServant = new RootFilterServant(queue);
        this._refman.bindToOrb(rootFilterServant, "iscream.Filter." + NAME);
        this._logger.write(this.toString(), 4, "started");
    }

    public boolean depCheck() {
        String string;
        Object object;
        try {
            object = this._refman.getCORBARef("iscream.ConfigurationManager");
        }
        catch (ComponentCORBAException componentCORBAException) {
            System.err.println(this.toString() + ": Dependency Failure: " + componentCORBAException);
            return false;
        }
        ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
        try {
            string = configurationProxy.getProperty("RootFilter", "RootFilter.realtimeInterfaceName");
            object = this._refman.getCORBARef("iscream.ClientInterface." + string);
        }
        catch (ComponentCORBAException componentCORBAException) {
            System.err.println(this.toString() + ": Dependency Failure: " + componentCORBAException);
            return false;
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            System.err.println(this.toString() + ": Client interface not configured and thus not enabled.");
        }
        try {
            string = configurationProxy.getProperty("RootFilter", "RootFilter.dbInterfaceName");
            object = this._refman.getCORBARef("iscream.ClientInterface." + string);
        }
        catch (ComponentCORBAException componentCORBAException) {
            System.err.println(this.toString() + ": Dependency Failure: " + componentCORBAException);
            return false;
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            System.err.println(this.toString() + ": Database interface not configured and thus not enabled.");
        }
        return true;
    }

    public String toString() {
        return FormatName.getName(NAME, this.getClass().getName(), REVISION);
    }
}

