/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.filtermanager;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.filtermanager.HostInit;
import uk.org.iscream.cms.server.util.FormatName;

class HostListener
extends Thread {
    public final String REVISION = "$Revision: 1.9 $";
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    private String _name = "FilterManager";

    public HostListener() {
        this.setName("filtermanager.HostListener");
        this._logger.write(this.toString(), 4, "started");
    }

    public void run() {
        ServerSocket serverSocket = null;
        boolean bl = true;
        try {
            int n = Integer.parseInt(ConfigurationProxy.getInstance().getProperty("FilterManager", "FilterManager.listenPort"));
            serverSocket = new ServerSocket(n);
            this._logger.write(this.toString(), 3, "Server listening on " + InetAddress.getLocalHost().getHostName() + "/" + InetAddress.getLocalHost().getHostAddress() + " port " + serverSocket.getLocalPort());
        }
        catch (UnknownHostException unknownHostException) {
            this._logger.write(this.toString(), 3, "Server listening on UnknownHost port " + serverSocket.getLocalPort());
        }
        catch (IOException iOException) {
            this._logger.write(this.toString(), 0, "IO Error, can't start FilterManager :" + iOException);
            bl = false;
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 0, "Fatal Error, can't find config :" + propertyNotFoundException);
            bl = false;
        }
        catch (NumberFormatException numberFormatException) {
            this._logger.write(this.toString(), 0, "Invalid port configuration found :" + numberFormatException);
            bl = false;
        }
        while (bl) {
            Socket socket = null;
            try {
                this._logger.write(this.toString(), 3, "Waiting for Connection");
                socket = serverSocket.accept();
                this._logger.write(this.toString(), 3, "Connection accepted from: " + socket.toString());
            }
            catch (IOException iOException) {
                bl = false;
            }
            if (!bl) continue;
            try {
                HostInit hostInit = new HostInit(socket);
                hostInit.start();
            }
            catch (IOException iOException) {
                this._logger.write(this.toString(), 1, iOException.toString());
            }
        }
        this._logger.write(this.toString(), 0, "Fatal error, shutdown pending");
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.9 $");
    }
}

