/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.filter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.ConfigurationManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.filter.FilterMain;
import uk.org.iscream.cms.server.filter.PluginServiceCheckManager;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.Queue;

class TCPReaderInit
extends Thread {
    public final String REVISION = "$Revision: 1.25 $";
    ConfigurationManager _configManager = ReferenceManager.getInstance().getCM();
    private String _name = FilterMain.NAME;
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    Socket _socket;
    BufferedReader _socketIn;
    PrintWriter _socketOut;
    Queue _queue;

    public TCPReaderInit(Socket socket, Queue queue) throws IOException {
        this.setName("filter.TCPReaderInit");
        this._socket = socket;
        this._queue = queue;
        this._socketIn = new BufferedReader(new InputStreamReader(this._socket.getInputStream()));
        this._socketOut = new PrintWriter(this._socket.getOutputStream(), true);
        this._logger.write(this.toString(), 4, "created");
    }

    public void run() {
        try {
            String string = "";
            String string2 = "";
            String string3 = "";
            this.getInBound("HEARTBEAT");
            this._socketOut.println("OK");
            this.getInBound("CONFIG");
            this._socketOut.println("OK");
            string = this.getInBound();
            this._socketOut.println("OK");
            string2 = this.getInBound();
            boolean bl = this._configManager.isModified(string, Long.parseLong(string2));
            if (bl) {
                this._socketOut.println("ERROR");
            } else {
                this._socketOut.println("OK");
            }
            this.getInBound("ENDHEARTBEAT");
            this._socketOut.println("OK");
            String string4 = new Long(System.currentTimeMillis() / 1000L).toString();
            String string5 = this._socket.getInetAddress().getHostName().toLowerCase();
            String string6 = this._socket.getInetAddress().getHostAddress();
            this._logger.write(this.toString(), 5, "Running service checks");
            String string7 = PluginServiceCheckManager.getInstance().runServiceChecks(string5);
            String string8 = "<packet type=\"heartbeat\" machine_name=\"" + string5 + "\" date=\"" + string4 + "\" ip=\"" + string6 + "\">" + string7 + "</packet>";
            this._queue.add(string8);
        }
        catch (Exception exception) {
            this._logger.write(this.toString(), 1, "ERROR: " + exception);
        }
        try {
            this._socketIn.close();
            this._socketOut.close();
            this._socket.close();
        }
        catch (IOException iOException) {
            this._logger.write(this.toString(), 1, "exception on socket close");
        }
        this._logger.write(this.toString(), 5, "finished");
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.25 $");
    }

    private String getInBound(String string) throws IOException {
        String string2 = this.getInBound();
        if (!string2.equals(string)) {
            throw new IOException("protocol error - expected:" + string + " got:" + string2);
        }
        return string2;
    }

    private String getInBound() throws IOException {
        String string = this._socketIn.readLine();
        if (string == null) {
            throw new IOException("got null from host, maybe it died");
        }
        return string;
    }
}

