/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.filter;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.filter.FilterMain;
import uk.org.iscream.cms.server.filter.TCPReaderInit;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.Queue;

class TCPReader
extends Thread {
    public final String REVISION = "$Revision: 1.12 $";
    private String _name = FilterMain.NAME;
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    private int _port;
    private Queue _queue;

    public TCPReader(int n, Queue queue) {
        this.setName("filter.TCPReader");
        this._port = n;
        this._queue = queue;
        this._logger.write(this.toString(), 4, "started");
    }

    public void run() {
        ServerSocket serverSocket = null;
        boolean bl = true;
        try {
            serverSocket = new ServerSocket(this._port);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this._logger.write(this.toString(), 3, "TCPReader listening on " + InetAddress.getLocalHost().getHostName() + "/" + InetAddress.getLocalHost().getHostAddress() + " port " + serverSocket.getLocalPort());
        }
        catch (UnknownHostException unknownHostException) {
            this._logger.write(this.toString(), 3, "TCPReader listening on UnknownHost port " + serverSocket.getLocalPort());
        }
        while (bl) {
            Socket socket = null;
            try {
                this._logger.write(this.toString(), 5, "Waiting for Connection");
                socket = serverSocket.accept();
                this._logger.write(this.toString(), 5, "Connection accepted from: " + socket.toString());
            }
            catch (IOException iOException) {
                bl = false;
            }
            if (!bl) continue;
            try {
                TCPReaderInit tCPReaderInit = new TCPReaderInit(socket, this._queue);
                tCPReaderInit.start();
            }
            catch (IOException iOException) {
                this._logger.write(this.toString(), 1, iOException.toString());
            }
        }
        this._logger.write(this.toString(), 0, "Fatal error, shutdown pending");
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.12 $");
    }
}

