/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.filter;

import java.util.HashMap;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.filter.FilterMain;
import uk.org.iscream.cms.server.filter.PluginServiceCheck;
import uk.org.iscream.cms.server.filter.PluginServiceCheckPipeline;
import uk.org.iscream.cms.server.util.FormatName;

class PluginServiceCheckManager {
    public final String REVISION = "$Revision: 1.6 $";
    private final String _suffix = "__ServiceCheck";
    private HashMap _hostPipelines = new HashMap();
    private HashMap _loadedServiceChecks = new HashMap();
    private String _name = FilterMain.NAME;
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    private ReferenceManager _refman = ReferenceManager.getInstance();
    private static PluginServiceCheckManager _instance;

    public static PluginServiceCheckManager getInstance() {
        if (_instance == null) {
            _instance = new PluginServiceCheckManager();
        }
        return _instance;
    }

    private PluginServiceCheckManager() {
        this._logger.write(this.toString(), 4, "created");
    }

    public String runServiceChecks(String string) {
        if (!this._hostPipelines.containsKey(string)) {
            this._hostPipelines.put(string, new PluginServiceCheckPipeline(string, this));
        }
        return "<services>" + ((PluginServiceCheckPipeline)this._hostPipelines.get(string)).runPipeline() + "</services>";
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.6 $");
    }

    public synchronized PluginServiceCheck getServiceCheck(String string) {
        this._logger.write(this.toString(), 5, "got request for service check - " + string);
        if (this._loadedServiceChecks.containsKey(string)) {
            this._logger.write(this.toString(), 5, string + " already loaded - returning reference to it.");
            return (PluginServiceCheck)this._loadedServiceChecks.get(string);
        }
        this._logger.write(this.toString(), 5, "attempting to load service check - " + string);
        PluginServiceCheck pluginServiceCheck = null;
        try {
            pluginServiceCheck = (PluginServiceCheck)ClassLoader.getSystemClassLoader().loadClass(string).newInstance();
            this._loadedServiceChecks.put(string, pluginServiceCheck);
            this._logger.write(this.toString(), 5, "loaded service check - " + string + " (" + pluginServiceCheck.getDescription() + ")");
        }
        catch (InstantiationException instantiationException) {
            this._logger.write(this.toString(), 1, "failed to instantiate - " + string);
            this._logger.write(this.toString(), 1, instantiationException.getMessage());
        }
        catch (Exception exception) {
            this._logger.write(this.toString(), 1, "failed to add - " + string);
            this._logger.write(this.toString(), 1, exception.toString());
        }
        return pluginServiceCheck;
    }
}

