/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.filter;

import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.filter.FilterMain;
import uk.org.iscream.cms.server.filter.PluginFilter;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.XMLPacket;

class PluginFilterManager {
    public final String REVISION = "$Revision: 1.9 $";
    private final String _suffix = "__Plugin";
    private LinkedList _filterPipeline = new LinkedList();
    private static PluginFilterManager _instance;
    private String _name = FilterMain.NAME;
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    private ReferenceManager _refman = ReferenceManager.getInstance();

    public static PluginFilterManager getInstance() {
        if (_instance == null) {
            _instance = new PluginFilterManager();
        }
        return _instance;
    }

    private PluginFilterManager() {
        String string;
        String string2;
        Object object;
        this._logger.write(this.toString(), 4, "Initialising");
        this._logger.write(this.toString(), 3, "Creating filter pipeline for plugin filters ...");
        try {
            object = ConfigurationProxy.getInstance();
            string2 = ((ConfigurationProxy)object).getProperty(FilterMain.NAME, "Filter.PluginsPackage");
            string = ((ConfigurationProxy)object).getProperty(FilterMain.NAME, "Filter.Plugins");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 2, "Unable to locate property: " + propertyNotFoundException);
            string = "";
            string2 = "";
        }
        object = new StringTokenizer(string, ";");
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string3 = string2 + "." + ((StringTokenizer)object).nextToken() + "__Plugin";
            this._logger.write(this.toString(), 5, "Attempting to create plugin: " + string3);
            try {
                PluginFilter pluginFilter = (PluginFilter)ClassLoader.getSystemClassLoader().loadClass(string3).newInstance();
                this._filterPipeline.add(pluginFilter);
                this._logger.write(this.toString(), 5, "Added filter: " + string3 + " (" + pluginFilter.getDescription() + ")");
            }
            catch (InstantiationException instantiationException) {
                this._logger.write(this.toString(), 1, "Failed to instantiate " + string3 + " to the plugin filter pipeline.");
                this._logger.write(this.toString(), 1, instantiationException.getMessage());
            }
            catch (Exception exception) {
                this._logger.write(this.toString(), 1, "Failed to add " + string3 + " to the plugin filter pipeline.");
                this._logger.write(this.toString(), 1, exception.toString());
            }
        }
        this._logger.write(this.toString(), 3, "The filter pipeline has been set up with " + this._filterPipeline.size() + " plugin filters.");
    }

    public boolean runFilters(XMLPacket xMLPacket) {
        ListIterator listIterator = this._filterPipeline.listIterator(0);
        while (listIterator.hasNext()) {
            PluginFilter pluginFilter = (PluginFilter)listIterator.next();
            if (pluginFilter.runFilter(xMLPacket)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.9 $");
    }
}

