/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.filter;

import java.net.InetAddress;
import java.net.UnknownHostException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.filter.FilterMain;
import uk.org.iscream.cms.server.filter.FilterPOA;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.Queue;

class FilterServant
extends FilterPOA {
    public final String REVISION = "$Revision: 1.18 $";
    private String _name = FilterMain.NAME;
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    private Queue _queue;
    private int _UDPListenPort;
    private int _TCPListenPort;

    public FilterServant(int n, int n2, Queue queue) {
        this._TCPListenPort = n;
        this._UDPListenPort = n2;
        this._queue = queue;
        this._logger.write(this.toString(), 4, "started");
    }

    public void receiveXML(String string) {
        this._queue.add(string);
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.18 $");
    }

    public String getUDPPort() {
        return new Integer(this._UDPListenPort).toString();
    }

    public String getTCPPort() {
        return new Integer(this._TCPListenPort).toString();
    }

    public String getHostName() {
        try {
            return InetAddress.getByName(InetAddress.getLocalHost().getHostAddress()).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this._logger.write(this.toString(), 1, unknownHostException.getMessage());
            return null;
        }
    }
}

