/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.filter;

import org.omg.CORBA.Object;
import org.omg.PortableServer.Servant;
import uk.org.iscream.cms.server.componentmanager.Component;
import uk.org.iscream.cms.server.componentmanager.ComponentCORBAException;
import uk.org.iscream.cms.server.componentmanager.ComponentStartException;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.filter.FilterServant;
import uk.org.iscream.cms.server.filter.FilterThread;
import uk.org.iscream.cms.server.filter.TCPReader;
import uk.org.iscream.cms.server.filter.UDPReader;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.StringUtils;

public class FilterMain
implements Component {
    public static final String REVISION = "$Revision: 1.31 $";
    private Logger _logger;
    private ReferenceManager _refman = ReferenceManager.getInstance();
    public static String NAME;

    public FilterMain(String string) {
        NAME = string;
    }

    public void start() throws ComponentStartException {
        Queue queue;
        java.lang.Object object;
        int n;
        int n2;
        int n3;
        this._logger = this._refman.getLogger();
        this._logger.write(this.toString(), 4, "coming up");
        ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
        try {
            n3 = Integer.parseInt(configurationProxy.getProperty(NAME, "Filter.UDPListenPort"));
            n2 = Integer.parseInt(configurationProxy.getProperty(NAME, "Filter.TCPListenPort"));
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            throw new ComponentStartException("Unable to obtain requried configuration property for component: " + propertyNotFoundException);
        }
        try {
            n = Integer.parseInt(configurationProxy.getProperty(NAME, "Queue.SizeLimit"));
            object = configurationProxy.getProperty(NAME, "Queue.RemoveAlgorithm");
            int n4 = StringUtils.getStringPos((String)object, Queue.algorithms);
            if (n4 != -1) {
                this._logger.write(this.toString(), 5, "Starting Queue with size limit of " + n + ", using remove algorithm " + (String)object);
                queue = new Queue(n, n4);
            } else {
                this._logger.write(this.toString(), 2, "Bad Queue Algorithm configuration, not known: " + (String)object);
                queue = new Queue();
            }
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 5, "Optional config not set: " + propertyNotFoundException);
            queue = new Queue();
        }
        catch (NumberFormatException numberFormatException) {
            this._logger.write(this.toString(), 2, "Bad Queue SizeLimit configuration: " + numberFormatException);
            queue = new Queue();
        }
        try {
            n = Integer.parseInt(configurationProxy.getProperty(NAME, "Queue.MonitorInterval"));
            object = NAME + " Filter";
            queue.startMonitor(n * 1000, (String)object);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 2, "failed to find queue monitor config, disabling. " + propertyNotFoundException);
        }
        this._logger.write(this.toString(), 4, "starting Filter Thread / Queue consumer");
        FilterThread filterThread = new FilterThread(queue);
        filterThread.start();
        this._logger.write(this.toString(), 5, "starting Servant to listen for downstream filters");
        object = new FilterServant(n2, n3, queue);
        this._refman.bindToOrb((Servant)object, "iscream.Filter." + NAME);
        this._logger.write(this.toString(), 4, "starting Filter UDP listener");
        UDPReader uDPReader = new UDPReader(n3, queue);
        uDPReader.start();
        this._logger.write(this.toString(), 4, "starting Filter TCP listener");
        TCPReader tCPReader = new TCPReader(n2, queue);
        tCPReader.start();
        this._logger.write(this.toString(), 4, "started");
    }

    public boolean depCheck() {
        try {
            Object object = this._refman.getCORBARef("iscream.ConfigurationManager");
            ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
            String string = configurationProxy.getProperty(NAME, "Filter.parentFilter");
            object = this._refman.getCORBARef("iscream.Filter." + string);
        }
        catch (ComponentCORBAException componentCORBAException) {
            System.err.println(this.toString() + ": Dependency Failure: " + componentCORBAException);
            return false;
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            System.err.println(this.toString() + ": Unable to obtain configuration: " + propertyNotFoundException);
            return false;
        }
        return true;
    }

    public String toString() {
        return FormatName.getName(NAME, this.getClass().getName(), REVISION);
    }
}

