/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.dbinterface;

import uk.org.iscream.cms.server.clientinterface.ClientInterfacePOA;
import uk.org.iscream.cms.server.componentmanager.ComponentStartException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.dbinterface.DBInterface;
import uk.org.iscream.cms.server.dbinterface.XMLPacketWrapper;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.InvalidXMLException;
import uk.org.iscream.cms.server.util.Queue;

public class DBServant
extends ClientInterfacePOA {
    public final String REVISION = "$Revision: 1.2 $";
    private Queue _queue;
    private String _name = DBInterface.NAME;
    private Logger _logger = ReferenceManager.getInstance().getLogger();

    public DBServant(Queue queue) throws ComponentStartException {
        this._queue = queue;
        this._logger.write(this.toString(), 4, "created");
    }

    public void receiveXML(String string) {
        XMLPacketWrapper xMLPacketWrapper = null;
        try {
            xMLPacketWrapper = new XMLPacketWrapper(string);
        }
        catch (InvalidXMLException invalidXMLException) {
            this._logger.write(this.toString(), 1, "Invalid XML: " + invalidXMLException);
            return;
        }
        this._queue.add(xMLPacketWrapper);
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.2 $");
    }
}

