/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.dbinterface;

import org.omg.CORBA.Object;
import uk.org.iscream.cms.server.componentmanager.Component;
import uk.org.iscream.cms.server.componentmanager.ComponentCORBAException;
import uk.org.iscream.cms.server.componentmanager.ComponentStartException;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.dbinterface.DBInserter;
import uk.org.iscream.cms.server.dbinterface.DBServant;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.StringUtils;

public class DBInterface
implements Component {
    public static final String REVISION = "$Revision: 1.14 $";
    private Logger _logger;
    private ReferenceManager _refman = ReferenceManager.getInstance();
    public static String NAME;

    public void start() throws ComponentStartException {
        Queue queue;
        java.lang.Object object;
        this._logger = this._refman.getLogger();
        this._logger.write(this.toString(), 4, "coming up");
        ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
        String string = "DBInterface";
        try {
            NAME = configurationProxy.getProperty(string, "DBInterface.name");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            NAME = null;
            this._logger.write(this.toString(), 2, "DBInterface name not set: " + propertyNotFoundException);
        }
        this._logger.write(this.toString(), 4, "configured");
        try {
            int n = Integer.parseInt(configurationProxy.getProperty(string, "Queue.SizeLimit"));
            object = configurationProxy.getProperty(string, "Queue.RemoveAlgorithm");
            int n2 = StringUtils.getStringPos((String)object, Queue.algorithms);
            if (n2 != -1) {
                this._logger.write(this.toString(), 5, "Starting Queue with size limit of " + n + ", using remove algorithm " + (String)object);
                queue = new Queue(n, n2);
            } else {
                this._logger.write(this.toString(), 2, "Bad Queue Algorithm configuration, not known: " + (String)object);
                queue = new Queue();
            }
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 5, "Optional config not set: " + propertyNotFoundException);
            queue = new Queue();
        }
        catch (NumberFormatException numberFormatException) {
            this._logger.write(this.toString(), 2, "Bad Queue SizeLimit configuration: " + numberFormatException);
            queue = new Queue();
        }
        this._logger.write(this.toString(), 5, "starting servant for inbound data");
        DBServant dBServant = new DBServant(queue);
        this._refman.bindToOrb(dBServant, "iscream.ClientInterface." + NAME);
        object = new DBInserter(queue);
        ((Thread)object).start();
        this._logger.write(this.toString(), 4, "started");
    }

    public boolean depCheck() {
        try {
            Object object = this._refman.getCORBARef("iscream.Logger");
            object = this._refman.getCORBARef("iscream.ConfigurationManager");
        }
        catch (ComponentCORBAException componentCORBAException) {
            System.err.println(this.toString() + ": Dependency Failure: " + componentCORBAException);
            return false;
        }
        return true;
    }

    public String toString() {
        return FormatName.getName(NAME, this.getClass().getName(), REVISION);
    }
}

