/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.dbinterface;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import uk.org.iscream.cms.server.componentmanager.ComponentStartException;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.dbinterface.DBInterface;
import uk.org.iscream.cms.server.dbinterface.XMLPacketWrapper;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.InvalidQueueException;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.XMLPacket;
import uk.org.iscream.cms.server.util.XMLPacketMaker;

public class DBInserter
extends Thread {
    public final String REVISION = "$Revision: 1.26 $";
    private String _mySQLUser;
    private String _mySQLPassword;
    private String _mySQLDatabase;
    private String _mySQLHost;
    private String _name = DBInterface.NAME;
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    private Queue _queue;
    private static XMLPacketMaker _xmlPacketMaker = new XMLPacketMaker();

    public DBInserter(Queue queue) throws ComponentStartException {
        this.setName("dbinterface.DBInserter");
        this._queue = queue;
        ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
        String string = "mySQL";
        try {
            this._mySQLUser = configurationProxy.getProperty(string, "mySQL.User");
            this._mySQLPassword = configurationProxy.getProperty(string, "mySQL.Password");
            this._mySQLHost = configurationProxy.getProperty(string, "mySQL.Host");
            this._mySQLDatabase = configurationProxy.getProperty(string, "mySQL.Database");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            throw new ComponentStartException("Essential mySQL config not found: " + propertyNotFoundException);
        }
        this._logger.write(this.toString(), 4, "created");
    }

    public void run() {
        int n = this._queue.getQueue();
        while (true) {
            XMLPacketWrapper xMLPacketWrapper = null;
            try {
                xMLPacketWrapper = (XMLPacketWrapper)this._queue.get(n);
            }
            catch (InvalidQueueException invalidQueueException) {
                this._logger.write(this.toString(), 1, "Queue error: " + invalidQueueException);
                continue;
            }
            this.addToDatabase(xMLPacketWrapper);
        }
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.26 $");
    }

    private void addToDatabase(XMLPacketWrapper xMLPacketWrapper) {
        XMLPacket xMLPacket = xMLPacketWrapper.getXMLPacket();
        String string = xMLPacket.getParam("packet.attributes.type");
        if (!string.equals("data")) {
            return;
        }
        String string2 = xMLPacket.getParam("packet.attributes.ip");
        String string3 = xMLPacket.getParam("packet.attributes.machine_name");
        String string4 = xMLPacket.getParam("packet.attributes.date");
        if (string2 == null || string3 == null || string4 == null || string2.equals("") || string3.equals("") || string4.equals("")) {
            this._logger.write(this.toString(), 5, "A packet reached DBInserter with some null essential fields - it will not be entered into the database.");
            return;
        }
        String string5 = xMLPacketWrapper.getXML();
        long l = xMLPacketWrapper.getTimestamp();
        try {
            String string6 = "jdbc:mysql://" + this._mySQLHost + "/" + this._mySQLDatabase + "?user=" + this._mySQLUser + "&password=" + this._mySQLPassword;
            Connection connection = DriverManager.getConnection(string6);
            PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO ipacket (ip, machine_name, sent_date, receipt_date, xml) VALUES (?, ?, ?, ?, ?);");
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string3);
            preparedStatement.setLong(3, Long.parseLong(string4));
            preparedStatement.setLong(4, l);
            preparedStatement.setString(5, string5);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            connection.close();
        }
        catch (SQLException sQLException) {
            this._logger.write(this.toString(), 1, "SQLException - " + sQLException.getMessage() + "\nSQLState: " + sQLException.getSQLState() + "\nVendorError: " + sQLException.getErrorCode());
        }
    }
}

