/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.core;

import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.ConfigurationPOA;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.util.FormatName;

class ConfigurationServant
extends ConfigurationPOA {
    public final String REVISION = "$Revision: 1.20 $";
    private Properties _properties = new Properties();
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    private ReferenceManager _refman = ReferenceManager.getInstance();
    private String _name = "Core";
    private long _lastModified;
    private String _fileList;

    ConfigurationServant(Properties properties, String string, long l) {
        this._properties = properties;
        this._lastModified = l;
        this._fileList = string;
        this._logger.write(this.toString(), 4, "created");
        String string2 = DateFormat.getDateTimeInstance(3, 2).format(new Date(this.getLastModified()));
        this._logger.write(this.toString(), 3, "last modified - " + string2);
        this._logger.write(this.toString(), 5, "file list - " + this._fileList);
    }

    public String getProperty(String string) {
        return this._properties.getProperty(string);
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.20 $");
    }

    public void disconnect() {
        try {
            byte[] byArray = this._refman.getRootPOA().servant_to_id(this);
            this._refman.getRootPOA().deactivate_object(byArray);
        }
        catch (Exception exception) {
            this._logger.write(this.toString(), 1, "disconnect failed: " + exception);
        }
    }

    protected void finalize() throws Throwable {
        this._logger.write(this.toString(), 5, "finalized");
    }

    public long getLastModified() {
        return this._lastModified;
    }

    public String getFileList() {
        return this._fileList;
    }
}

