/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.clientinterface;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import uk.org.iscream.cms.server.clientinterface.ClientInterfaceMain;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.InvalidQueueException;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.StringUtils;

class TCPDataHandler
extends Thread {
    public final String REVISION = "$Revision: 1.13 $";
    private String _name = ClientInterfaceMain.NAME;
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    private BufferedReader _socketIn;
    private PrintWriter _socketOut;
    private Socket _socket;
    private Queue _queue;
    private boolean run;
    private int _queueID;

    public TCPDataHandler(Socket socket) throws IOException {
        this.setName("clientinterface.TCPDataHandler");
        ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
        String string = "ClientInterface";
        try {
            int n = Integer.parseInt(configurationProxy.getProperty(string, "Queue.SizeLimit"));
            String string2 = configurationProxy.getProperty(string, "Queue.RemoveAlgorithm");
            int n2 = StringUtils.getStringPos(string2, Queue.algorithms);
            if (n2 != -1) {
                this._logger.write(this.toString(), 5, "Starting Queue with size limit of " + n + ", using remove algorithm " + string2);
                this._queue = new Queue(n, n2);
            } else {
                this._logger.write(this.toString(), 2, "Bad Queue Algorithm configuration, not known: " + string2);
                this._queue = new Queue();
            }
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 5, "Optional config not set: " + propertyNotFoundException);
            this._queue = new Queue();
        }
        catch (NumberFormatException numberFormatException) {
            this._logger.write(this.toString(), 2, "Bad Queue SizeLimit configuration: " + numberFormatException);
            this._queue = new Queue();
        }
        this._socket = socket;
        this._socketIn = new BufferedReader(new InputStreamReader(this._socket.getInputStream()));
        this._socketOut = new PrintWriter(this._socket.getOutputStream(), true);
        this._logger.write(this.toString(), 4, "created");
    }

    public void run() {
        this.run = true;
        this._queueID = this._queue.getQueue();
        while (this.run) {
            try {
                String string = (String)this._queue.get(this._queueID);
                if (string == null) continue;
                this._socketOut.println(string);
            }
            catch (InvalidQueueException invalidQueueException) {
                this.run = false;
                this._logger.write(this.toString(), 1, "Queue failure: " + invalidQueueException);
            }
        }
        this._logger.write(this.toString(), 3, "Shutting Down");
        try {
            this._socketOut.close();
            this._socketIn.close();
            this._socket.close();
        }
        catch (IOException iOException) {
            this._logger.write(this.toString(), 1, "Exception whilst shutting down: " + iOException);
        }
        this._queue.removeQueue(this._queueID);
        this._queue.stopMonitor();
    }

    public void shutdown() {
        this.run = false;
        this._queue.releaseQueue(this._queueID);
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.13 $");
    }

    public Queue getQueue() {
        return this._queue;
    }
}

