/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.clientinterface;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import uk.org.iscream.cms.server.clientinterface.ClientInterfaceMain;
import uk.org.iscream.cms.server.clientinterface.PacketSorter;
import uk.org.iscream.cms.server.clientinterface.TCPDataHandler;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.ConfigurationManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.util.FormatName;

class TCPControlHandler
extends Thread {
    public final String REVISION = "$Revision: 1.23 $";
    public static final String PROTOVER = "PROTOCOL 1.1";
    private String _name = ClientInterfaceMain.NAME;
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    private ConfigurationManager _configManager = ReferenceManager.getInstance().getCM();
    private Socket _socket;
    private BufferedReader _socketIn;
    private PrintWriter _socketOut;
    private PacketSorter _packetSorter;
    private TCPDataHandler _dataHandler;
    private String _clientName;
    private String _hostList;

    public TCPControlHandler(Socket socket, PacketSorter packetSorter) throws IOException {
        this.setName("clientinterface.TCPControlHandler");
        this._socket = socket;
        this._packetSorter = packetSorter;
        this._socketIn = new BufferedReader(new InputStreamReader(this._socket.getInputStream()));
        this._socketOut = new PrintWriter(this._socket.getOutputStream(), true);
        this._hostList = "";
        this._logger.write(this.toString(), 4, "created");
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        var1_1 = true;
        try {
            this.send("PROTOCOL 1.1");
            this._clientName = this._socketIn.readLine();
            if (this._clientName == null) {
                throw new IOException("Fatal error reading from client");
            }
            this.sendOK();
        }
        catch (IOException var2_2) {
            this._logger.write(this.toString(), 0, "Fatal error, shutdown pending");
            var1_1 = false;
        }
        this._logger.write(this.toString(), 5, "Client has connected: " + this._clientName);
        while (var1_1) {
            try {
                block30: {
                    var2_3 = this._socketIn.readLine();
                    if (var2_3 == null) {
                        throw new IOException("Fatal error reading from client");
                    }
                    if (!var2_3.equals("STARTCONFIG")) break block30;
                    var3_5 = ConfigurationProxy.getInstance();
                    this.sendOK();
                    var2_3 = this._socketIn.readLine();
                    if (var2_3 != null) ** GOTO lbl50
                    throw new IOException("Fatal error reading from client");
lbl-1000:
                    // 1 sources

                    {
                        block29: {
                            var4_6 = var2_3.indexOf(";");
                            if (var4_6 != -1) {
                                try {
                                    var5_8 = var2_3.substring(0, var4_6);
                                    var6_9 = var2_3.substring(var4_6 + 1, var2_3.length());
                                    if (!var5_8.equals("") && !var6_9.equals("")) {
                                        if ((var6_9.startsWith("Client.") || var6_9.startsWith("Host.")) && (var5_8.startsWith("Client.") || var5_8.startsWith("Host."))) {
                                            try {
                                                var7_10 = var3_5.getProperty((String)var5_8, (String)var6_9);
                                                this.send((String)var7_10);
                                            }
                                            catch (PropertyNotFoundException var7_11) {
                                                this.sendERROR();
                                            }
                                        } else {
                                            this.sendERROR();
                                        }
                                        break block29;
                                    }
                                    this.sendERROR();
                                }
                                catch (IndexOutOfBoundsException var7_12) {
                                    this.sendERROR();
                                }
                            } else {
                                this.sendERROR();
                            }
                        }
                        var2_3 = this._socketIn.readLine();
                        if (var2_3 != null) continue;
                        throw new IOException("Fatal error reading from client");
lbl50:
                        // 2 sources

                        ** while (!var2_3.equals((Object)"ENDCONFIG"))
                    }
lbl51:
                    // 1 sources

                    this.sendOK();
                    this._logger.write(this.toString(), 5, "Client has been configured");
                    continue;
                }
                if (var2_3.equals("STARTDATA")) {
                    if (this._dataHandler == null) {
                        var3_5 = new ServerSocket(0);
                        var4_7 = new Integer(var3_5.getLocalPort()).toString();
                        this.send(var4_7);
                        var5_8 = var3_5.accept();
                        var6_9 = new TCPDataHandler((Socket)var5_8);
                        this._packetSorter.register(var6_9.getQueue(), this._hostList);
                        try {
                            var7_10 = ConfigurationProxy.getInstance();
                            var8_14 = Integer.parseInt(var7_10.getProperty("ClientInterface", "Queue.MonitorInterval"));
                            var9_15 = this._name + " TCPHandler:" + this._socket.getInetAddress().getHostName();
                            var6_9.getQueue().startMonitor(var8_14 * 1000, this._packetSorter.getQueue(), var9_15);
                        }
                        catch (PropertyNotFoundException var7_13) {
                            this._logger.write(this.toString(), 2, "failed to find queue monitor config, disabling. " + var7_13);
                        }
                        var6_9.start();
                        this._dataHandler = var6_9;
                        this.sendOK();
                        this._logger.write(this.toString(), 5, "Data stream started at Clients Request on port: " + var4_7);
                        continue;
                    }
                    this.sendERROR();
                    continue;
                }
                if (var2_3.equals("STOPDATA")) {
                    if (this.closeData()) {
                        this.sendOK();
                        this._logger.write(this.toString(), 5, "Data stream stopped at Clients Request");
                        continue;
                    }
                    this.sendERROR();
                    continue;
                }
                if (var2_3.equals("SETHOSTLIST")) {
                    if (this._dataHandler == null) {
                        this.sendOK();
                        var2_3 = this._socketIn.readLine();
                        if (var2_3 == null) {
                            throw new IOException("Fatal error reading from client");
                        }
                        this._hostList = var2_3;
                        this.sendOK();
                        continue;
                    }
                    this.sendERROR();
                    continue;
                }
                if (var2_3.equals("DISCONNECT")) {
                    var1_1 = false;
                    if (this.closeData()) {
                        this._logger.write(this.toString(), 5, "Data stream stopped at Clients Request");
                    }
                    this.sendOK();
                    this._socketIn.close();
                    this._socketOut.close();
                    this._socket.close();
                    this._logger.write(this.toString(), 5, "Closing at Clients Request");
                    continue;
                }
                this.sendERROR();
            }
            catch (IOException var2_4) {
                var1_1 = false;
                this._logger.write(this.toString(), 0, "Fatal communication error, shutdown pending");
            }
        }
        if (this.closeData()) {
            this._logger.write(this.toString(), 5, "Data stream stopped due to fatal client error");
        }
        this._logger.write(this.toString(), 5, "Shutting down Control Handler, client has gone.");
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.23 $");
    }

    private boolean closeData() {
        if (this._dataHandler != null) {
            this._packetSorter.deregister(this._dataHandler.getQueue(), this._hostList);
            this._dataHandler.shutdown();
            this._dataHandler = null;
            return true;
        }
        return false;
    }

    private void sendOK() {
        this.send("OK");
    }

    private void sendERROR() {
        this.send("ERROR");
    }

    private void send(String string) {
        this._socketOut.println(string);
    }
}

