/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.clientinterface;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import uk.org.iscream.cms.server.clientinterface.ClientInterfaceMain;
import uk.org.iscream.cms.server.clientinterface.PacketSorter;
import uk.org.iscream.cms.server.clientinterface.TCPControlHandler;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.util.FormatName;

class TCPClientListener
extends Thread {
    public final String REVISION = "$Revision: 1.13 $";
    public static final int DEFPORT = 4510;
    private String _name = ClientInterfaceMain.NAME;
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    private PacketSorter _packetSorter;

    public TCPClientListener(PacketSorter packetSorter) {
        this.setName("clientinterface.TCPClientListener");
        this._packetSorter = packetSorter;
        this._logger.write(this.toString(), 4, "started");
    }

    public void run() {
        int n;
        Object object;
        try {
            object = ConfigurationProxy.getInstance().getProperty("ClientInterface", "ClientInterface.listenPort");
            n = Integer.parseInt((String)object);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            n = 4510;
            this._logger.write(this.toString(), 2, "Configuration not found, using default of " + n + " : " + propertyNotFoundException);
        }
        catch (NumberFormatException numberFormatException) {
            n = 4510;
            this._logger.write(this.toString(), 2, "Bad configuration found, using default of " + n + " : " + numberFormatException);
        }
        object = null;
        boolean bl = true;
        try {
            object = new ServerSocket(n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this._logger.write(this.toString(), 3, "ClientListener listening on " + InetAddress.getLocalHost().getHostName() + "/" + InetAddress.getLocalHost().getHostAddress() + " port " + ((ServerSocket)object).getLocalPort());
        }
        catch (UnknownHostException unknownHostException) {
            this._logger.write(this.toString(), 3, "ClientListener listening on UnknownHost port " + ((ServerSocket)object).getLocalPort());
        }
        while (bl) {
            Socket socket = null;
            try {
                this._logger.write(this.toString(), 3, "Waiting for Connection");
                socket = ((ServerSocket)object).accept();
                this._logger.write(this.toString(), 3, "Connection accepted from: " + socket.toString());
            }
            catch (IOException iOException) {
                bl = false;
            }
            if (!bl) continue;
            try {
                TCPControlHandler tCPControlHandler = new TCPControlHandler(socket, this._packetSorter);
                tCPControlHandler.start();
            }
            catch (IOException iOException) {
                this._logger.write(this.toString(), 1, iOException.toString());
            }
        }
        this._logger.write(this.toString(), 0, "Fatal error, shutdown pending");
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.13 $");
    }
}

