/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.clientinterface;

import java.util.AbstractSequentialList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import uk.org.iscream.cms.server.clientinterface.ClientInterfaceMain;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.InvalidQueueException;
import uk.org.iscream.cms.server.util.InvalidXMLException;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.StringUtils;
import uk.org.iscream.cms.server.util.XMLPacket;
import uk.org.iscream.cms.server.util.XMLPacketMaker;

class PacketSorter
extends Thread {
    public final String REVISION = "$Revision: 1.18 $";
    private String _name = ClientInterfaceMain.NAME;
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    private Queue _queue;
    private HashMap _hostMap;
    private LinkedList _allHostDataList;
    private LinkedList _allHostsList;

    public PacketSorter() {
        String string;
        int n;
        this.setName("clientinterface.PacketSorter");
        ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
        String string2 = "ClientInterface";
        try {
            n = Integer.parseInt(configurationProxy.getProperty(string2, "Queue.SizeLimit"));
            string = configurationProxy.getProperty(string2, "Queue.RemoveAlgorithm");
            int n2 = StringUtils.getStringPos(string, Queue.algorithms);
            if (n2 != -1) {
                this._logger.write(this.toString(), 5, "Starting Queue with size limit of " + n + ", using remove algorithm " + string);
                this._queue = new Queue(n, n2);
            } else {
                this._logger.write(this.toString(), 2, "Bad Queue Algorithm configuration, not known: " + string);
                this._queue = new Queue();
            }
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 5, "Optional config not set: " + propertyNotFoundException);
            this._queue = new Queue();
        }
        catch (NumberFormatException numberFormatException) {
            this._logger.write(this.toString(), 2, "Bad Queue SizeLimit configuration: " + numberFormatException);
            this._queue = new Queue();
        }
        try {
            n = Integer.parseInt(configurationProxy.getProperty(string2, "Queue.MonitorInterval"));
            string = this._name + " PacketSorterQueue";
            this._queue.startMonitor(n * 1000, string);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 2, "failed to find queue monitor config, disabling. " + propertyNotFoundException);
        }
        this._hostMap = new HashMap();
        this._allHostDataList = new LinkedList();
        this._allHostsList = new LinkedList();
        this._logger.write(this.toString(), 4, "created");
    }

    public void run() {
        XMLPacketMaker xMLPacketMaker = new XMLPacketMaker();
        int n = this._queue.getQueue();
        while (true) {
            Object object;
            Object object2;
            String string = "";
            try {
                string = (String)this._queue.get(n);
            }
            catch (InvalidQueueException invalidQueueException) {
                this._logger.write(this.toString(), 1, "Queue failure: " + invalidQueueException);
            }
            XMLPacket xMLPacket = null;
            try {
                xMLPacket = xMLPacketMaker.createXMLPacket(string);
            }
            catch (InvalidXMLException invalidXMLException) {
                this._logger.write(this.toString(), 1, "Invalid XML: " + invalidXMLException);
                continue;
            }
            String string2 = xMLPacket.getParam("packet.attributes.type");
            if (string2.equals("data") || string2.equals("heartbeat")) {
                Iterator iterator;
                Object object3;
                object2 = xMLPacket.getParam("packet.attributes.machine_name");
                object = this;
                synchronized (object) {
                    if (this._hostMap.containsKey(object2)) {
                        object3 = (LinkedList)this._hostMap.get(object2);
                        iterator = ((AbstractSequentialList)object3).iterator();
                        while (iterator.hasNext()) {
                            ((Queue)iterator.next()).add(string);
                        }
                    }
                }
                object3 = this;
                synchronized (object3) {
                    iterator = this._allHostDataList.iterator();
                    while (iterator.hasNext()) {
                        ((Queue)iterator.next()).add(string);
                    }
                }
            }
            object2 = this;
            synchronized (object2) {
                object = this._allHostsList.iterator();
                while (object.hasNext()) {
                    ((Queue)object.next()).add(string);
                }
            }
        }
    }

    public void register(Queue queue, String string) {
        Object object;
        if (string.equals("")) {
            object = this;
            synchronized (object) {
                this._allHostDataList.add(queue);
            }
            this._logger.write(this.toString(), 3, "registered DataHandler for all hosts");
        } else {
            object = new StringTokenizer(string, ";");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                PacketSorter packetSorter = this;
                synchronized (packetSorter) {
                    List<Queue> list;
                    if (this._hostMap.containsKey(string2)) {
                        list = (List)this._hostMap.get(string2);
                        list.add(queue);
                    } else {
                        list = new LinkedList<Queue>();
                        ((LinkedList)list).add(queue);
                        this._hostMap.put(string2, list);
                    }
                }
            }
            this._logger.write(this.toString(), 3, "registered DataHandler for hosts: " + string);
        }
        object = this;
        synchronized (object) {
            this._allHostsList.add(queue);
        }
    }

    public void deregister(Queue queue, String string) {
        Object object;
        if (string.equals("")) {
            object = this;
            synchronized (object) {
                this._allHostDataList.remove(queue);
            }
            this._logger.write(this.toString(), 3, "deregistered DataHandler for all hosts");
        } else {
            object = new StringTokenizer(string, ";");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                PacketSorter packetSorter = this;
                synchronized (packetSorter) {
                    if (this._hostMap.containsKey(string2)) {
                        LinkedList linkedList = (LinkedList)this._hostMap.get(string2);
                        linkedList.remove(queue);
                        if (linkedList.size() == 0) {
                            this._hostMap.remove(string2);
                        }
                    }
                }
            }
            this._logger.write(this.toString(), 3, "deregistered DataHandler for hosts: " + string);
        }
        object = this;
        synchronized (object) {
            this._allHostsList.remove(queue);
        }
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.18 $");
    }

    public Queue getQueue() {
        return this._queue;
    }
}

