/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.clientinterface;

import uk.org.iscream.cms.server.client.Client;
import uk.org.iscream.cms.server.clientinterface.ClientInterfaceMain;
import uk.org.iscream.cms.server.clientinterface.CorbaControlHandlerPOA;
import uk.org.iscream.cms.server.clientinterface.CorbaDataHandler;
import uk.org.iscream.cms.server.clientinterface.PacketSorter;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.util.FormatName;

class CorbaControlHandlerServant
extends CorbaControlHandlerPOA {
    public final String REVISION = "$Revision: 1.14 $";
    private String _name = ClientInterfaceMain.NAME;
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    private ReferenceManager _refman = ReferenceManager.getInstance();
    private PacketSorter _packetSorter;
    private String _hostList;
    private Client _client;
    private CorbaDataHandler _dataHandler;
    private String _clientname;

    public CorbaControlHandlerServant(PacketSorter packetSorter, Client client, String string) {
        this._packetSorter = packetSorter;
        this._hostList = "";
        this._client = client;
        this._clientname = string;
        this._dataHandler = null;
        this._logger.write(this.toString(), 4, "created");
    }

    public boolean startData() {
        if (this._dataHandler == null) {
            CorbaDataHandler corbaDataHandler = new CorbaDataHandler(this._client, this);
            this._packetSorter.register(corbaDataHandler.getQueue(), this._hostList);
            try {
                ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
                int n = Integer.parseInt(configurationProxy.getProperty("ClientInterface", "Queue.MonitorInterval"));
                String string = this._name + " CorbaHandler:" + this._clientname;
                corbaDataHandler.getQueue().startMonitor(n * 1000, this._packetSorter.getQueue(), string);
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                this._logger.write(this.toString(), 2, "failed to find queue monitor config, disabling. " + propertyNotFoundException);
            }
            corbaDataHandler.start();
            this._dataHandler = corbaDataHandler;
            return true;
        }
        return false;
    }

    public boolean stopData() {
        if (this._dataHandler != null) {
            this._packetSorter.deregister(this._dataHandler.getQueue(), this._hostList);
            this._dataHandler.shutdown();
            this._dataHandler = null;
            return true;
        }
        return false;
    }

    public boolean setHostList(String string) {
        if (this._dataHandler == null) {
            this._hostList = string;
            return true;
        }
        return false;
    }

    public void disconnect() {
        this.stopData();
        try {
            byte[] byArray = this._refman.getRootPOA().servant_to_id(this);
            this._refman.getRootPOA().deactivate_object(byArray);
        }
        catch (Exception exception) {
            this._logger.write(this.toString(), 1, "disconnect failed: " + exception);
        }
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.14 $");
    }

    protected void finalize() throws Throwable {
        this._logger.write(this.toString(), 5, "finalized by GC");
    }
}

