/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.client.monitors;

import uk.org.iscream.cms.server.client.MonitorManager;
import uk.org.iscream.cms.server.client.PluginMonitor;
import uk.org.iscream.cms.server.client.WebFeeder;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.InvalidQueueException;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.XMLPacket;

public class WebFeeder__Monitor
extends Thread
implements PluginMonitor {
    public static final String REVISION = "$Revision: 1.7 $";
    public static final String DESC = "Provides a feed to WebFeeder";
    private String _name = "WebFeeder";
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    protected int _qID = -1;
    protected boolean _running = true;

    public WebFeeder__Monitor() {
        this.start();
    }

    public void run() {
        while (this._running) {
            try {
                this.analysePacket((XMLPacket)this.getQueue().get(this.getQueueId()));
            }
            catch (InvalidQueueException invalidQueueException) {
                this._logger.write(this.toString(), 1, "Unable to get queue.");
            }
        }
    }

    public void analysePacket(XMLPacket xMLPacket) {
        try {
            ConfigurationProxy.getInstance().getProperty("WebFeeder", "WebFeeder.latestActive");
            WebFeeder.getInstance().receiveXMLPacket(xMLPacket);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            // empty catch block
        }
    }

    public String getDescription() {
        return DESC;
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), REVISION);
    }

    protected Queue getQueue() {
        return MonitorManager.getInstance().getAllQueue();
    }

    protected int getQueueId() {
        if (this._qID == -1) {
            this._qID = this.getQueue().getQueue();
        }
        return this._qID;
    }
}

