/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.client.monitors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import uk.org.iscream.cms.server.client.MonitorManager;
import uk.org.iscream.cms.server.client.MonitorSkeleton;
import uk.org.iscream.cms.server.client.Register;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.XMLPacket;

public class Services__Monitor
extends MonitorSkeleton {
    public final String REVISION = "$Revision: 1.5 $";
    public final String DESC = "Monitors a hosts services.";
    private String _name = "Services";
    private HashMap _hosts = new HashMap();

    public void analysePacket(XMLPacket xMLPacket) {
        String string = xMLPacket.getParam("packet.attributes.machine_name");
        if (!this._hosts.containsKey(string)) {
            this._hosts.put(string, new HashMap());
        }
        HashMap hashMap = (HashMap)this._hosts.get(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "packet.services.";
        Set set = xMLPacket.getSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string3.startsWith(string2) || arrayList.contains(string3)) continue;
            String string4 = "";
            int n = string2.length();
            while (string3.charAt(n) != '.') {
                string4 = string4 + string3.charAt(n);
                ++n;
            }
            arrayList.add(string2 + string4 + ".attributes.status");
            String string5 = xMLPacket.getParam(string2 + string4 + ".attributes.status");
            arrayList.add(string2 + string4 + ".attributes.message");
            String string6 = xMLPacket.getParam(string2 + string4 + ".attributes.message");
            if (!hashMap.containsKey(string4)) {
                hashMap.put(string4, new Register(string, this._name));
            }
            Register register = (Register)hashMap.get(string4);
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string5);
            }
            catch (NumberFormatException numberFormatException) {
                this._logger.write(this.toString(), 2, "Received heartbeat from " + string + " with bad service information: " + numberFormatException);
                break;
            }
            String string7 = string4 + " service";
            String string8 = "";
            string8 = n2 == 0 ? "RUNNING" : "FAILED";
            this.processAlert(n2, string7, register, string, string8);
        }
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.5 $");
    }

    public String getDescription() {
        return "Monitors a hosts services.";
    }

    protected Queue getQueue() {
        return MonitorManager.getInstance().getHeartbeatQueue();
    }
}

