/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.client.monitors;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import uk.org.iscream.cms.server.client.Alert;
import uk.org.iscream.cms.server.client.MonitorManager;
import uk.org.iscream.cms.server.client.MonitorSkeleton;
import uk.org.iscream.cms.server.client.Register;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.XMLPacket;

public class Queue__Monitor
extends MonitorSkeleton {
    public final String REVISION = "$Revision: 1.13 $";
    public final String DESC = "Who watches the watchmen?";
    private final String SOURCE = "i-scream-server";
    private String _name = "Queue";
    private ConfigurationProxy _cp = ConfigurationProxy.getInstance();
    private HashMap _hosts = new HashMap();

    public void analysePacket(XMLPacket xMLPacket) {
        if (xMLPacket.getParam("packet.attributes.type").equals("queueStat")) {
            String string = xMLPacket.getParam("packet.attributes.hashCode");
            if (!this._hosts.containsKey(string)) {
                this._hosts.put(string, new HashMap());
            }
            HashMap hashMap = (HashMap)this._hosts.get(string);
            String string2 = xMLPacket.getParam("packet.attributes.name");
            String string3 = xMLPacket.getParam("packet.queue.attributes.maxSize");
            Set set = xMLPacket.getSet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string4;
                double d;
                double d2;
                double d3;
                String string5 = (String)iterator.next();
                if (!string5.startsWith("packet.queue.attributes.queue")) continue;
                String string6 = xMLPacket.getParam(string5);
                if (string6.equals("[deleted]")) break;
                if (!hashMap.containsKey(string5)) {
                    hashMap.put(string5, new Register(this._name, this._name));
                }
                Register register = (Register)hashMap.get(string5);
                try {
                    if (string3 == null || string6 == null) {
                        throw new NumberFormatException("Queue data invalid");
                    }
                    d3 = Double.parseDouble(string3);
                    d2 = Double.parseDouble(string6);
                }
                catch (NumberFormatException numberFormatException) {
                    this._logger.write(this.toString(), 2, "Received packet from " + string + " with bad queue information: " + numberFormatException);
                    break;
                }
                boolean bl = false;
                try {
                    String string7 = this._cp.getProperty(this._name, "Monitor." + this._name + ".thresholdMeasure");
                    if (string7.equals("VALUE")) {
                        bl = true;
                    }
                }
                catch (PropertyNotFoundException propertyNotFoundException) {
                    // empty catch block
                }
                if (bl) {
                    d = d2;
                    string4 = "count";
                } else {
                    d = d2 / d3 * 100.0;
                    string4 = "%";
                }
                int n = this.checkAttributeThreshold(d, register);
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setMaximumFractionDigits(2);
                numberFormat.setMinimumFractionDigits(2);
                String string8 = numberFormat.format(d);
                String string9 = "Size of queue " + string4 + " in " + string2 + " " + string5.substring(string5.lastIndexOf(46) + 1);
                this.processAlert(n, string9, register, "i-scream-server", string8);
            }
        }
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.13 $");
    }

    public String getDescription() {
        return "Who watches the watchmen?";
    }

    private int checkAttributeThreshold(double d, Register register) {
        int n = Alert.thresholdLevels.length - 1;
        while (n >= 0) {
            if (register.getThreshold(n) != -1.0 && register.getThreshold(n) < d) {
                return n;
            }
            --n;
        }
        return 0;
    }

    protected Queue getQueue() {
        return MonitorManager.getInstance().getOtherQueue();
    }
}

