/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.client.monitors;

import java.text.NumberFormat;
import java.util.HashMap;
import uk.org.iscream.cms.server.client.Alert;
import uk.org.iscream.cms.server.client.MonitorManager;
import uk.org.iscream.cms.server.client.MonitorSkeleton;
import uk.org.iscream.cms.server.client.Register;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.XMLPacket;

public class Memory__Monitor
extends MonitorSkeleton {
    public final String REVISION = "$Revision: 1.8 $";
    public final String DESC = "Monitors Memory.";
    private String _name = "Memory";
    private ConfigurationProxy _cp = ConfigurationProxy.getInstance();
    private HashMap _hosts = new HashMap();

    public void analysePacket(XMLPacket xMLPacket) {
        double d;
        double d2;
        String string;
        String string2 = xMLPacket.getParam("packet.attributes.machine_name");
        if (!this._hosts.containsKey(string2)) {
            this._hosts.put(string2, new Register(string2, this._name));
        }
        Register register = (Register)this._hosts.get(string2);
        String string3 = "Memory In Use %";
        try {
            String string4 = xMLPacket.getParam("packet.memory.total");
            string = xMLPacket.getParam("packet.memory.free");
            if (string4 == null || string == null) {
                throw new NumberFormatException("Memory data invalid");
            }
            d2 = Double.parseDouble(string4);
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            this._logger.write(this.toString(), 2, "Received packet from " + string2 + " with bad memory information: " + numberFormatException);
            return;
        }
        boolean bl = false;
        try {
            string = this._cp.getProperty("Host." + string2, "Monitor." + this._name + ".thresholdMeasure");
            if (string.equals("VALUE")) {
                bl = true;
            }
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            // empty catch block
        }
        double d3 = bl ? d2 - d : (1.0 - d / d2) * 100.0;
        int n = this.checkAttributeThreshold(d3, register);
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(2);
        String string5 = numberFormat.format(d3);
        this.processAlert(n, string3, register, string2, string5);
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.8 $");
    }

    public String getDescription() {
        return "Monitors Memory.";
    }

    private int checkAttributeThreshold(double d, Register register) {
        int n = Alert.thresholdLevels.length - 1;
        while (n >= 0) {
            if (register.getThreshold(n) != -1.0 && register.getThreshold(n) < d) {
                return n;
            }
            --n;
        }
        return 0;
    }

    protected Queue getQueue() {
        return MonitorManager.getInstance().getDataQueue();
    }
}

