/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.client.monitors;

import java.util.HashMap;
import java.util.Iterator;
import uk.org.iscream.cms.server.client.Alert;
import uk.org.iscream.cms.server.client.MonitorManager;
import uk.org.iscream.cms.server.client.MonitorSkeleton;
import uk.org.iscream.cms.server.client.Register;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.XMLPacket;

public class Heartbeat__Monitor
extends MonitorSkeleton {
    public final String REVISION = "$Revision: 1.20 $";
    public final String DESC = "Monitors Heartbeats.";
    public final int DEFAULT_CHECK_PERIOD = 60;
    private String _name = "Heartbeat";
    private ConfigurationProxy _cp = ConfigurationProxy.getInstance();
    private HashMap _hosts = new HashMap();
    private Logger _logger = ReferenceManager.getInstance().getLogger();

    public Heartbeat__Monitor() {
        new HeartbeatWorker().start();
    }

    public void analysePacket(XMLPacket xMLPacket) {
        Object object;
        String string = xMLPacket.getParam("packet.attributes.machine_name");
        if (!this._hosts.containsKey(string)) {
            object = this;
            synchronized (object) {
                this._hosts.put(string, new HeartbeatHolder(new Register(string, this._name)));
            }
        }
        object = (HeartbeatHolder)this._hosts.get(string);
        ((HeartbeatHolder)object).setLastHeartbeat(System.currentTimeMillis() / 1000L);
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.20 $");
    }

    public String getDescription() {
        return "Monitors Heartbeats.";
    }

    private int checkAttributeThreshold(long l, Register register) {
        int n = Alert.thresholdLevels.length - 1;
        while (n >= 0) {
            if (register.getThreshold(n) != -1.0 && (long)register.getThreshold(n) < l) {
                return n;
            }
            --n;
        }
        return 0;
    }

    protected Queue getQueue() {
        return MonitorManager.getInstance().getHeartbeatQueue();
    }

    private class HeartbeatWorker
    extends Thread {
        private HeartbeatWorker() {
        }

        public void run() {
            ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
            while (true) {
                int n = 0;
                try {
                    n = Integer.parseInt(configurationProxy.getProperty(Heartbeat__Monitor.this._name, "Monitor.Heartbeat.checkPeriod"));
                }
                catch (PropertyNotFoundException propertyNotFoundException) {
                    n = 60;
                    Heartbeat__Monitor.this._logger.write(Heartbeat__Monitor.this.toString(), 2, "Monitor.Heartbeat.checkPeriod value unavailable using default of " + n + " seconds");
                }
                catch (NumberFormatException numberFormatException) {
                    n = 60;
                    Heartbeat__Monitor.this._logger.write(Heartbeat__Monitor.this.toString(), 2, "Erronous Monitor.Heartbeat.checkPeriod value in configuration using default of " + n + " seconds");
                }
                Heartbeat__Monitor heartbeat__Monitor = Heartbeat__Monitor.this;
                synchronized (heartbeat__Monitor) {
                    Iterator iterator = Heartbeat__Monitor.this._hosts.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        boolean bl = this.analyseHB(string);
                        if (!bl) continue;
                        iterator.remove();
                    }
                }
                try {
                    Thread.sleep(n * 1000);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private boolean analyseHB(String string) {
            ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
            HeartbeatHolder heartbeatHolder = (HeartbeatHolder)Heartbeat__Monitor.this._hosts.get(string);
            Register register = heartbeatHolder.getRegister();
            int n = 0;
            try {
                n = Integer.parseInt(configurationProxy.getProperty("Host." + string, "Host.TCPUpdateTime"));
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                n = 0;
                Heartbeat__Monitor.this._logger.write(Heartbeat__Monitor.this.toString(), 2, "TCPUpdateTime value unavailable using default of " + n + " seconds");
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
                Heartbeat__Monitor.this._logger.write(Heartbeat__Monitor.this.toString(), 2, "Erronous TCPUpdateTime value in configuration using default of " + n + " seconds");
            }
            long l = heartbeatHolder.getLastHeartbeat();
            long l2 = System.currentTimeMillis() / 1000L - l;
            long l3 = l2 - (long)n;
            if (l3 < 0L) {
                l3 = 0L;
            }
            int n2 = Heartbeat__Monitor.this.checkAttributeThreshold(l3, register);
            Heartbeat__Monitor.super.processAlert(n2, "Heartbeat", register, string, String.valueOf(l3));
            return register.getLastAlertLevel() == 5;
        }
    }

    private class HeartbeatHolder {
        private long _lastHeartbeat;
        private Register _register;

        public HeartbeatHolder(Register register) {
            this._register = register;
        }

        public void setLastHeartbeat(long l) {
            this._lastHeartbeat = l;
        }

        public long getLastHeartbeat() {
            return this._lastHeartbeat;
        }

        public Register getRegister() {
            return this._register;
        }
    }
}

