/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.client.monitors;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import uk.org.iscream.cms.server.client.Alert;
import uk.org.iscream.cms.server.client.MonitorManager;
import uk.org.iscream.cms.server.client.MonitorSkeleton;
import uk.org.iscream.cms.server.client.Register;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.XMLPacket;

public class Disk__Monitor
extends MonitorSkeleton {
    public final String REVISION = "$Revision: 1.9 $";
    public final String DESC = "Monitors all host disks.";
    private String _name = "Disk";
    private ConfigurationProxy _cp = ConfigurationProxy.getInstance();
    private HashMap _hosts = new HashMap();

    public void analysePacket(XMLPacket xMLPacket) {
        String string = xMLPacket.getParam("packet.attributes.machine_name");
        if (!this._hosts.containsKey(string)) {
            this._hosts.put(string, new HashMap());
        }
        HashMap hashMap = (HashMap)this._hosts.get(string);
        String string2 = "packet.disk.p";
        ArrayList<String> arrayList = new ArrayList<String>();
        Set set = xMLPacket.getSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3;
            double d;
            double d2;
            double d3;
            String string4 = (String)iterator.next();
            if (!string4.startsWith(string2) || arrayList.contains(string4)) continue;
            String string5 = "";
            int n = string2.length();
            while (string4.charAt(n) != '.') {
                string5 = string5 + string4.charAt(n);
                ++n;
            }
            arrayList.add(string2 + string5 + ".attributes.used");
            arrayList.add(string2 + string5 + ".attributes.name");
            String string6 = xMLPacket.getParam(string2 + string5 + ".attributes.name");
            arrayList.add(string2 + string5 + ".attributes.mount");
            String string7 = xMLPacket.getParam(string2 + string5 + ".attributes.mount");
            arrayList.add(string2 + string5 + ".attributes.kbytes");
            String string8 = xMLPacket.getParam(string2 + string5 + ".attributes.kbytes");
            arrayList.add(string2 + string5 + ".attributes.avail");
            String string9 = xMLPacket.getParam(string2 + string5 + ".attributes.avail");
            if (!hashMap.containsKey(string5)) {
                hashMap.put(string5, new Register(string, this._name, string7));
            }
            Register register = (Register)hashMap.get(string5);
            try {
                if (string8 == null || string9 == null) {
                    throw new NumberFormatException("Disk data invalid");
                }
                d3 = Double.parseDouble(string8);
                d2 = Double.parseDouble(string9);
            }
            catch (NumberFormatException numberFormatException) {
                this._logger.write(this.toString(), 2, "Received packet from " + string + " with bad disk information: " + numberFormatException);
                break;
            }
            boolean bl = false;
            try {
                String string10 = this._cp.getProperty("Host." + string, "Monitor." + this._name + ".thresholdMeasure");
                if (string10.equals("VALUE")) {
                    bl = true;
                }
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
            if (bl) {
                d = d3 - d2;
                string3 = "kb";
            } else {
                d = (1.0 - d2 / d3) * 100.0;
                string3 = "%";
            }
            int n2 = this.checkAttributeThreshold(d, register);
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setMinimumFractionDigits(2);
            String string11 = numberFormat.format(d);
            String string12 = "Disk in use " + string3 + " on " + string7 + " (" + string6 + ")";
            this.processAlert(n2, string12, register, string, string11);
        }
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.9 $");
    }

    public String getDescription() {
        return "Monitors all host disks.";
    }

    private int checkAttributeThreshold(double d, Register register) {
        int n = Alert.thresholdLevels.length - 1;
        while (n >= 0) {
            if (register.getThreshold(n) != -1.0 && register.getThreshold(n) < d) {
                return n;
            }
            --n;
        }
        return 0;
    }

    protected Queue getQueue() {
        return MonitorManager.getInstance().getDataQueue();
    }
}

