/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.client.monitors;

import java.util.HashMap;
import uk.org.iscream.cms.server.client.Alert;
import uk.org.iscream.cms.server.client.MonitorManager;
import uk.org.iscream.cms.server.client.MonitorSkeleton;
import uk.org.iscream.cms.server.client.Register;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.XMLPacket;

public class CPU__Monitor
extends MonitorSkeleton {
    public final String REVISION = "$Revision: 1.24 $";
    public final String DESC = "Monitors CPU.";
    private String _name = "CPU";
    private HashMap _hosts = new HashMap();
    private String[] _attributes = new String[]{"packet.cpu.user", "packet.cpu.kernel", "packet.cpu.iowait", "packet.cpu.swap"};
    private String[] _attributeNames = new String[]{"User CPU", "Kernel CPU", "I/O Wait CPU", "Swap CPU"};

    public void analysePacket(XMLPacket xMLPacket) {
        HashMap hashMap;
        String string = xMLPacket.getParam("packet.attributes.machine_name");
        if (!this._hosts.containsKey(string)) {
            hashMap = new HashMap();
            this.initAttributeRegsiters(string, hashMap);
            this._hosts.put(string, hashMap);
        }
        hashMap = (HashMap)this._hosts.get(string);
        int n = 0;
        while (n < this._attributes.length) {
            Register register = (Register)hashMap.get(this._attributes[n]);
            String string2 = this._attributes[n];
            String string3 = this._attributeNames[n];
            String string4 = xMLPacket.getParam(string2);
            int n2 = this.checkAttributeThreshold(string4, register);
            this.processAlert(n2, string3, register, string, string4);
            ++n;
        }
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.24 $");
    }

    public String getDescription() {
        return "Monitors CPU.";
    }

    private int checkAttributeThreshold(String string, Register register) {
        int n = Alert.thresholdLevels.length - 1;
        while (n >= 0) {
            if (register.getThreshold(n) != -1.0 && string != null) {
                try {
                    double d = Double.parseDouble(string);
                    if (register.getThreshold(n) < d) {
                        return n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this._logger.write(this.toString(), 5, "possible errenous packet data, should be double value - " + string);
                }
            }
            --n;
        }
        return 0;
    }

    private void initAttributeRegsiters(String string, HashMap hashMap) {
        int n = 0;
        while (n < this._attributes.length) {
            String string2 = this._attributes[n].substring(this._attributes[n].lastIndexOf(".") + 1);
            hashMap.put(this._attributes[n], new Register(string, this._name, string2));
            ++n;
        }
    }

    protected Queue getQueue() {
        return MonitorManager.getInstance().getDataQueue();
    }
}

